/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SpacePageUtils {
    private static final Log LOG = ExoLogger.getLogger(SpacePageUtils.class);
    private static final String MODIFIED_GROUP_ID_PREFERENCE = "{modifiedGroupId}";

    public static void convert(List<?> children, String groupId) {
        if (children == null || children.size() == 0) {
            return;
        }
        for (Object child : children) {
            if (child instanceof Container) {
                Container container = (Container)child;
                SpacePageUtils.convert(container.getChildren(), groupId);
                continue;
            }
            if (!(child instanceof Application) || !((Application)child).getType().equals(ApplicationType.PORTLET)) continue;
            Application application = (Application)child;
            try {
                String nodeIdentifier;
                String folderPath;
                Portlet portlet = SpacePageUtils.getPreferences((Application<Portlet>)application);
                if (portlet == null) continue;
                boolean modified = false;
                if (portlet.getPreference("folderPath") != null && !StringUtils.isBlank((String)(folderPath = portlet.getPreference("folderPath").getValue()))) {
                    String newFolderPath = SpacePageUtils.convertPath(folderPath, groupId);
                    portlet.setValue("folderPath", newFolderPath);
                    modified = true;
                }
                if (portlet.getPreference("nodeIdentifier") != null && !StringUtils.isBlank((String)(nodeIdentifier = portlet.getPreference("nodeIdentifier").getValue()))) {
                    String newNodeIdentifier = SpacePageUtils.convertPath(nodeIdentifier, groupId);
                    portlet.setValue("nodeIdentifier", newNodeIdentifier);
                    modified = true;
                }
                modified |= SpacePageUtils.changeDriveName(groupId, portlet, "nodeDrive");
                if (!(modified |= SpacePageUtils.changeDriveName(groupId, portlet, "driveName"))) continue;
                SpacePageUtils.savePreferences((ApplicationState<Portlet>)application.getState(), portlet);
            }
            catch (Exception e) {
                LOG.error((Object)("Can't convert CLV application preferences " + application.getId()), (Throwable)e);
            }
        }
    }

    private static boolean changeDriveName(String groupId, Portlet portlet, String nodeDrive) {
        boolean modified = false;
        if (portlet.getPreference(nodeDrive) != null && portlet.getPreference(nodeDrive).getValue() != null && portlet.getPreference(nodeDrive).getValue().contains(MODIFIED_GROUP_ID_PREFERENCE)) {
            String driveName = portlet.getPreference(nodeDrive).getValue();
            String newFolderPath = driveName.replace(MODIFIED_GROUP_ID_PREFERENCE, groupId.replace("/", "."));
            portlet.setValue(nodeDrive, newFolderPath);
            modified = true;
        }
        return modified;
    }

    private static String convertPath(String originalPath, String groupId) {
        if (StringUtils.isEmpty((String)originalPath)) {
            return originalPath;
        }
        return originalPath.replaceAll("@owner@", groupId);
    }

    private static Portlet getPreferences(Application<Portlet> application) throws Exception {
        DataStorage dataStorage = (DataStorage)PortalContainer.getInstance().getComponentInstanceOfType(DataStorage.class);
        return (Portlet)dataStorage.load(application.getState(), application.getType());
    }

    private static void savePreferences(ApplicationState<Portlet> state, Portlet portlet) throws Exception {
        DataStorage dataStorage = (DataStorage)PortalContainer.getInstance().getComponentInstanceOfType(DataStorage.class);
        dataStorage.save(state, (Object)portlet);
    }
}

