/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dto.BasicEntityDTO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.exception.EntityAlreadyExistsException;
import org.exoplatform.cs.service.BaseService;
import org.exoplatform.cs.service.CSHandlerStarter;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSpaceService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(CSSpaceService.class);
    private static final String CUSTOMERS_GROUP = "exo.cs.customers.group";
    private CSHandlerStarter csHandlerStarter;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private TicketService ticketService;

    public CSSpaceService(SpaceDAO spaceDAO, SpaceService spaceService, CSHandlerStarter csHandlerStarter, OrganizationService organizationService, TicketService ticketService) {
        super(null, spaceDAO, null, null);
        this.spaceService = spaceService;
        this.organizationService = organizationService;
        this.csHandlerStarter = csHandlerStarter;
        this.ticketService = ticketService;
    }

    public SpaceDTO getSpace(String groupId) throws Exception {
        SpaceEntity entity = this.getSpaceEntityByGroupId(groupId);
        if (entity == null) {
            return null;
        }
        return this.convertToDTO(entity);
    }

    private SpaceEntity getSpaceEntityByGroupId(String groupId) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Method getSpace - Parameter 'groupId' is null");
        }
        if (!groupId.startsWith("/spaces")) {
            throw new IllegalArgumentException("Method getSpace - Parameter 'groupId' format is not know, it should start with: /spaces");
        }
        SpaceEntity entity = null;
        try {
            entity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)groupId));
        }
        catch (Exception e) {
            LOG.debug("Error while getting space with groupId {}", (Object)groupId);
        }
        return entity;
    }

    public void removeSpace(String groupId) throws Exception {
        SpaceEntity entity = this.getSpaceEntityByGroupId(groupId);
        if (entity != null) {
            this.spaceDAO.delete(entity);
        } else {
            LOG.warn("Cannot delete cs space entity with group id '{}' because it wasn't found", (Object)groupId);
        }
    }

    public List<SpaceDTO> getAllSpaces() {
        List entities = this.spaceDAO.findAll();
        ArrayList<SpaceDTO> dtos = new ArrayList<SpaceDTO>();
        for (SpaceEntity entity : entities) {
            SpaceDTO space = this.convertToDTO(entity);
            if (space == null) continue;
            dtos.add(space);
        }
        return dtos;
    }

    public Map<String, String> getAllSpaceNames() {
        List entities = this.spaceDAO.findAll();
        HashMap<String, String> spaces = new HashMap<String, String>();
        for (SpaceEntity entity : entities) {
            String spaceName = this.spaceService.getSpaceByGroupId(entity.getGroupId()).getDisplayName();
            spaces.put(spaceName, entity.getGroupId());
        }
        return spaces;
    }

    public List<SpaceDTO> getSpaces(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getSpaces - Parameter 'offset' must be positive");
        }
        List<SpaceEntity> entities = this.spaceDAO.getSpaces(offset, limit);
        ArrayList<SpaceDTO> dtos = new ArrayList<SpaceDTO>();
        for (SpaceEntity entity : entities) {
            dtos.add(this.convertToDTO(entity));
        }
        return dtos;
    }

    public long getSpacesCount() {
        return this.spaceDAO.getSpacesCount();
    }

    public SpaceDTO updateSpace(SpaceDTO spaceDTO) throws Exception {
        Space space = this.spaceService.getSpaceByGroupId(spaceDTO.getGroupId());
        space.setType("CSSpace");
        this.spaceService.updateSpace(space);
        return this.save(spaceDTO);
    }

    public SpaceDTO saveSpace(SpaceDTO spaceDTO) throws Exception {
        if (spaceDTO == null) {
            throw new IllegalArgumentException("Method save - Parameter 'spaceDTO' is null");
        }
        if (!spaceDTO.verifySaveConditions()) {
            throw new IllegalStateException("spaceDTO is not valid: " + spaceDTO);
        }
        Group group = this.organizationService.getGroupHandler().findGroupById(spaceDTO.getName());
        if (group != null) {
            throw new EntityAlreadyExistsException("Space already exists with name: " + spaceDTO.getName());
        }
        Space space = new Space();
        space.setDisplayName(spaceDTO.getName());
        space.setDescription(spaceDTO.getDescription());
        space.setPrettyName(spaceDTO.getName());
        space.setType("CSSpace");
        space.setVisibility("hidden");
        space.setRegistration("validation");
        space.setEditor(spaceDTO.getOwner());
        if (spaceDTO.getManagersGroupId() != null) {
            space = this.setManagers(spaceDTO, space);
        }
        if (spaceDTO.getMembers() != null) {
            space = this.setMembers(spaceDTO, space);
        }
        if (spaceDTO.getInvitedMembersGroupId() != null) {
            space = this.addInvitedMembers(spaceDTO, space);
        }
        this.csHandlerStarter.addHandlerToSpaceService();
        space = this.spaceService.createSpace(space, spaceDTO.getOwner());
        spaceDTO.setUrl(space.getUrl());
        spaceDTO.setGroupId(space.getGroupId());
        this.addMembersToGlobalCustomerGroup(spaceDTO);
        for (String member : space.getMembers()) {
            try {
                SpaceUtils.addUserToGroupWithMemberMembership((String)member, (String)space.getGroupId());
            }
            catch (Exception e) {
                LOG.warn("  Cannot add member '" + member + "' to space: " + space.getPrettyName(), (Throwable)e);
            }
        }
        for (String manager : space.getManagers()) {
            try {
                SpaceUtils.addUserToGroupWithManagerMembership((String)manager, (String)space.getGroupId());
            }
            catch (Exception e) {
                LOG.warn("  Cannot add manager '" + manager + "' to space: " + space.getPrettyName(), (Throwable)e);
            }
        }
        return this.save(spaceDTO);
    }

    private void addMembersToGlobalCustomerGroup(SpaceDTO spaceDTO) throws Exception {
        String customerGroupName = System.getProperty(CUSTOMERS_GROUP);
        if (StringUtils.isBlank((CharSequence)customerGroupName)) {
            customerGroupName = "customers";
        }
        if (spaceDTO.getMembers() != null && !spaceDTO.getMembers().isEmpty()) {
            HashSet members = new HashSet();
            for (BasicEntityDTO member : spaceDTO.getMembers()) {
                if (member == null || member.computeId() == null) continue;
                if (this.organizationService.getUserHandler().findUserByName(member.computeId()) == null) {
                    throw new IllegalStateException("User with id '" + member + "' not found");
                }
                SpaceUtils.addUserToGroupWithMemberMembership((String)member.computeId(), (String)customerGroupName);
            }
        }
    }

    private SpaceDTO save(SpaceDTO spaceDTO) {
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)spaceDTO.getGroupId()));
        if (spaceEntity == null) {
            spaceEntity = this.convertToEntity(spaceDTO, new SpaceEntity());
            this.spaceDAO.create(spaceEntity);
        } else {
            spaceEntity = this.convertToEntity(spaceDTO, spaceEntity);
            this.spaceDAO.update(spaceEntity);
        }
        return spaceDTO;
    }

    private Space setMembers(SpaceDTO spaceDTO, Space space) throws Exception {
        if (spaceDTO.getMembers() != null && !spaceDTO.getMembers().isEmpty()) {
            HashSet<String> members = new HashSet<String>();
            for (BasicEntityDTO member : spaceDTO.getMembers()) {
                if (member == null || member.computeId() == null) continue;
                if (this.organizationService.getUserHandler().findUserByName(member.computeId()) == null) {
                    throw new IllegalStateException("User with id '" + member + "' not found");
                }
                members.add(member.computeId());
            }
            members.addAll(Arrays.asList(space.getManagers()));
            members.add(spaceDTO.getTaskDefaultAssignee().computeId());
            space.setMembers(members.toArray(new String[0]));
        }
        return space;
    }

    private Space setManagers(SpaceDTO spaceDTO, Space space) throws Exception {
        if (spaceDTO.getManagersGroupId() != null) {
            Group group = this.organizationService.getGroupHandler().findGroupById(spaceDTO.getManagersGroupId().computeId());
            if (group == null) {
                throw new IllegalStateException("Managers group with id '" + spaceDTO.getManagersGroupId() + "' doesn't exist");
            }
            ListAccess members = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
            Membership[] memberships = (Membership[])members.load(0, members.getSize());
            HashSet<String> managers = new HashSet<String>();
            for (Membership membership : memberships) {
                managers.add(membership.getUserName().trim());
            }
            space.setManagers(managers.toArray(new String[0]));
        }
        return space;
    }

    private Space addInvitedMembers(SpaceDTO spaceDTO, Space space) throws Exception {
        if (spaceDTO.getInvitedMembersGroupId() != null) {
            Group group = this.organizationService.getGroupHandler().findGroupById(spaceDTO.getInvitedMembersGroupId().computeId());
            if (group == null) {
                throw new IllegalStateException("Members group with id '" + spaceDTO.getInvitedMembersGroupId() + "' doesn't exist");
            }
            ListAccess members = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
            Membership[] memberships = (Membership[])members.load(0, members.getSize());
            HashSet<String> invitedMembers = new HashSet<String>();
            for (Membership membership : memberships) {
                invitedMembers.add(membership.getUserName().trim());
            }
            ArrayList<String> memberList = new ArrayList<String>();
            if (space.getMembers() != null && space.getMembers().length > 0) {
                memberList = new ArrayList<String>(Arrays.asList(space.getMembers()));
            }
            memberList.addAll(invitedMembers);
            space.setMembers(memberList.toArray(new String[0]));
        }
        return space;
    }

    private SpaceEntity convertToEntity(SpaceDTO spaceDTO, SpaceEntity spaceEntity) {
        spaceEntity.setGroupId(spaceDTO.getGroupId());
        spaceEntity.setTagIndex(spaceDTO.getTagIndex());
        spaceEntity.setManagersGroupId(spaceDTO.getManagersGroupId() == null ? null : spaceDTO.getManagersGroupId().computeId());
        spaceEntity.setInvitedMembersGroupId(spaceDTO.getInvitedMembersGroupId() == null ? null : spaceDTO.getInvitedMembersGroupId().computeId());
        spaceEntity.setTagPrefix(spaceDTO.getTagPrefix());
        spaceEntity.setTaskDefaultAssignee(spaceDTO.getTaskDefaultAssignee() == null ? null : spaceDTO.getTaskDefaultAssignee().computeId());
        spaceEntity.setIncidentFlow(spaceDTO.getIncidentFlow());
        spaceEntity.setInformationFlow(spaceDTO.getInformationFlow());
        spaceEntity.setTaskPriority(spaceDTO.getTaskPriority());
        spaceEntity.setLimitTicketsNumber(spaceDTO.getLimitTicketsNumber());
        spaceEntity.setHosted(spaceDTO.isHosted());
        spaceEntity.setLanguage(spaceDTO.getLanguage());
        return spaceEntity;
    }

    private SpaceDTO convertToDTO(SpaceEntity spaceEntity) {
        Space space = this.spaceService.getSpaceByGroupId(spaceEntity.getGroupId());
        if (space != null) {
            SpaceDTO spaceDTO = new SpaceDTO();
            spaceDTO.setGroupId(spaceEntity.getGroupId());
            spaceDTO.setTagIndex(spaceEntity.getTagIndex());
            spaceDTO.setManagersGroupId(new BasicEntityDTO("@" + spaceEntity.getManagersGroupId(), spaceEntity.getManagersGroupId()));
            spaceDTO.setInvitedMembersGroupId(new BasicEntityDTO("@" + spaceEntity.getInvitedMembersGroupId(), spaceEntity.getInvitedMembersGroupId()));
            spaceDTO.setTagPrefix(spaceEntity.getTagPrefix());
            spaceDTO.setTaskDefaultAssignee(new BasicEntityDTO("@" + spaceEntity.getTaskDefaultAssignee(), spaceEntity.getTaskDefaultAssignee()));
            spaceDTO.setTaskPriority(spaceDTO.getTaskPriority());
            spaceDTO.setLimitTicketsNumber(spaceEntity.getLimitTicketsNumber());
            Long supportTickets = this.ticketService.getTicketsCount(spaceEntity, IssueType.INCIDENT) + this.ticketService.getTicketsCount(spaceEntity, IssueType.INFORMATION);
            Long productTickets = this.ticketService.getTicketsCount(spaceEntity, IssueType.PRODUCT);
            spaceDTO.setSupportTickets(supportTickets);
            spaceDTO.setProductTickets(productTickets);
            spaceDTO.setTotalTickets(supportTickets + productTickets);
            spaceDTO.setInformationFlow(spaceEntity.getInformationFlow());
            spaceDTO.setIncidentFlow(spaceEntity.getIncidentFlow());
            spaceDTO.setLanguage(spaceEntity.getLanguage());
            spaceDTO.setName(space.getDisplayName());
            spaceDTO.setDescription(space.getDescription());
            spaceDTO.setHosted(spaceEntity.isHosted());
            return spaceDTO;
        }
        return null;
    }

    private int getSupportTicketsNumber(SpaceEntity spaceEntity) {
        List<TicketDTO> tickets = this.ticketService.getTicketsOfSpace(spaceEntity.getGroupId());
        ArrayList<TicketDTO> SupportTickets = new ArrayList<TicketDTO>();
        for (TicketDTO ticket : tickets) {
            if (!IssueType.INFORMATION.equals((Object)ticket.getType()) && !IssueType.INCIDENT.equals((Object)ticket.getType())) continue;
            SupportTickets.add(ticket);
        }
        return SupportTickets.size();
    }

    private int getProductTicketsNumber(SpaceEntity spaceEntity) {
        List<TicketDTO> tickets = this.ticketService.getTicketsOfSpace(spaceEntity.getGroupId());
        ArrayList<TicketDTO> ProductTickets = new ArrayList<TicketDTO>();
        for (TicketDTO ticket : tickets) {
            if (!IssueType.PRODUCT.equals((Object)ticket.getType())) continue;
            ProductTickets.add(ticket);
        }
        return ProductTickets.size();
    }

    private int getTotalTicketsNumber(SpaceEntity spaceEntity) {
        List<TicketDTO> tickets = this.ticketService.getTicketsOfSpace(spaceEntity.getGroupId());
        return tickets.size();
    }
}

