/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinNameApplicationLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SkinNameApplicationLifecycle.class);
    private static final String CSSKIN = "CSSkin";
    private static final String CSSKIN_PATH = "/customer-space-skin/skin/css/Style.css";
    private static final String EMPTY_CSSKIN_PATH = "/customer-space-skin/skin/css/EmptyStyle.css";

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        UIPortalApplication uiApp = (UIPortalApplication)pcontext.getUIApplication();
        try {
            if (pcontext.isResponseComplete()) {
                return;
            }
            String siteName = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
            String siteType = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_TYPE);
            Site site = null;
            Portal portal = PortalRequest.getInstance().getPortal();
            site = siteType.equalsIgnoreCase(org.exoplatform.portal.mop.SiteType.GROUP.name()) ? portal.getSite(new SiteId(new Group(siteName))) : (siteType.equalsIgnoreCase(org.exoplatform.portal.mop.SiteType.USER.name()) ? portal.getSite(new SiteId(new User(siteName))) : portal.getSite(new SiteId(SiteType.SITE, siteName)));
            SkinService skinService = (SkinService)uiApp.getApplicationComponent(SkinService.class);
            String skinName = uiApp.getSkin();
            if (site != null) {
                if (CSSKIN.equals(site.getSkin())) {
                    skinService.addPortalSkin(CSSKIN, skinName, CSSKIN_PATH, true);
                } else {
                    skinService.addPortalSkin(CSSKIN, skinName, EMPTY_CSSKIN_PATH, true);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error while setting skin name, set default one", (Throwable)e);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

