/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.SpaceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceDAO
extends GenericDAOJPAImpl<SpaceEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceDAO.class);

    public List<SpaceEntity> getSpaces(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("spaceEntity.findAllOrderBy", SpaceEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.findAll();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get spaces with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getSpacesCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("spaceEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get spaces count.", (Throwable)e);
            throw e;
        }
    }
}

