/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.job;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.User;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoAssignJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(AutoAssignJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
        TicketService ticketService = (TicketService)containerContext.getComponentInstanceOfType(TicketService.class);
        TopicDAO topicDAO = (TopicDAO)((Object)containerContext.getComponentInstanceOfType(TopicDAO.class));
        ListenerService listenerService = (ListenerService)containerContext.getComponentInstanceOfType(ListenerService.class);
        List<TopicEntity> tickets = topicDAO.getNotAssignedTickets();
        Calendar calendar = Calendar.getInstance();
        for (TopicEntity ticket : tickets) {
            if (ticket.getFirstWarningDate() != null && ticket.getFirstWarningDate().before(calendar) && ticket.getAssignee() == null) {
                try {
                    HashMap<String, Integer> usersMap = new HashMap<String, Integer>();
                    for (User user : CSUtils.getSupportAutoAssignees()) {
                        usersMap.put(user.getUserName(), 0);
                    }
                    List<Object> results = new ArrayList();
                    results = topicDAO.countUnresolvedTicketsGroupdByAssignee();
                    String assignee = "";
                    int ticketNumber = 5000;
                    for (int i = 0; i < results.size(); ++i) {
                        Object[] arr = (Object[])results.get(i);
                        if ((String)arr[0] == null || !usersMap.containsKey((String)arr[0])) continue;
                        usersMap.put((String)arr[0], ((Long)arr[1]).intValue());
                    }
                    for (Map.Entry entry : usersMap.entrySet()) {
                        if ((Integer)entry.getValue() != 0) continue;
                        assignee = (String)entry.getKey();
                        break;
                    }
                    if (assignee.equals("")) {
                        for (Map.Entry entry : usersMap.entrySet()) {
                            if ((Integer)entry.getValue() >= ticketNumber) continue;
                            assignee = (String)entry.getKey();
                        }
                    }
                    ticket.setAssignee(assignee);
                    topicDAO.update(ticket);
                    HashMap<String, String> changes = new HashMap<String, String>();
                    changes.put("ticket.assignee.old", null);
                    changes.put("ticket.assignee.new", assignee);
                    changes.put("user.id", "support");
                    listenerService.broadcast("exo.addons.cs.ticket.updated", (Object)ticket, changes);
                    LOG.info("Ticket {} has been assigned to {}", (Object)ticket.getId(), (Object)assignee);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            LOG.info("Auto Assignement finished");
        }
    }
}

