/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import juzu.impl.request.EntityMarshaller;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.jackson.Jackson;

public class JacksonMarshaller
extends EntityMarshaller {
    public Streamable marshall(String mimeType, AnnotatedElement annotations, Object object) {
        if (mimeType.equals("application/json")) {
            byte[] data;
            if (object instanceof TreeNode) {
                try {
                    TreeNode tree = (TreeNode)object;
                    JsonFactory jfactory = new JsonFactory();
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    JsonGenerator generator = jfactory.createGenerator((OutputStream)buffer);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeTree(generator, tree);
                    data = buffer.toByteArray();
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("handle me gracefully", e);
                }
            } else if (annotations.getAnnotation(Jackson.class) != null) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    mapper.writeValue((OutputStream)buffer, object);
                    data = buffer.toByteArray();
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("handle me gracefully", e);
                }
            } else {
                data = null;
            }
            if (data != null) {
                return new Streamable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void send(Stream stream) throws IllegalStateException {
                        try {
                            stream.provide((Chunk)Chunk.create((byte[])data));
                        }
                        finally {
                            stream.close(null);
                        }
                    }
                };
            }
        }
        return null;
    }
}

