/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;

@Entity(name="CSTopicEntity")
@ExoEntity
@Table(name="CS_ADDON_TOPICS")
@NamedQueries(value={@NamedQuery(name="topicEntity.getTopicsBySpace", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndAssignee", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.assignee = :assignee order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndAssigneeAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.assignee = :assignee AND a.status = status order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsBySpace", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID and a.status != :closedStatus order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsBySpaceAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID and (a.status = :status and a.status != :closedStatus) order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsByStatus", query="SELECT a FROM CSTopicEntity a where (a.status = :status and a.status != :closedStatus) order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByAssignee", query="SELECT a FROM CSTopicEntity a where a.assignee = :assignee order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByAssigneeAndStatus", query="SELECT a FROM CSTopicEntity a where a.assignee = :assignee AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopics", query="SELECT a FROM CSTopicEntity a where (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByAssignee", query="SELECT a FROM CSTopicEntity a where a.assignee = :assignee AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.findAllTicketByStatus", query="SELECT a FROM CSTopicEntity a where a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByAssigneeAndSpace", query="SELECT a FROM CSTopicEntity a where a.assignee = :assignee AND a.space.id = :spaceGroupID AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.findUpdatedTopics", query="SELECT a FROM CSTopicEntity a where a.updateDate >= :from AND a.updateDate <= :to order by updateDate desc"), @NamedQuery(name="topicEntity.findEmptyTitleAndCreationDateTopics", query="SELECT a FROM CSTopicEntity a where a.title is null or a.title='' or a.creationDate is null or a.creationDate is EMPTY order by updateDate desc"), @NamedQuery(name="topicEntity.findTicketByTicketId", query="SELECT a FROM CSTopicEntity a where a.ticketId = :ticketId"), @NamedQuery(name="topicEntity.findEmptyTicketID", query="SELECT a FROM CSTopicEntity a where ( a.ticketId is null or a.ticketId = '' ) AND a.type != 1"), @NamedQuery(name="topicEntity.countTickets", query="SELECT count(a) FROM CSTopicEntity a where a.type = :type AND a.space = :space"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndCreator", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.creator = :creator order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndCreatorAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.creator = :creator AND a.status = status order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByCreator", query="SELECT a FROM CSTopicEntity a where a.creator = :creator order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByCreatorAndStatus", query="SELECT a FROM CSTopicEntity a where a.creator = :creator AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByCreator", query="SELECT a FROM CSTopicEntity a where a.creator = :creator AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByCreatorAndSpace", query="SELECT a FROM CSTopicEntity a where a.creator = :creator AND a.space.id = :spaceGroupID AND (a.status is null or a.status != :status) order by updateDate desc")})
public class TopicEntity {
    @Id
    @Column(name="TOPIC_ID")
    private String id;
    @Column(name="TYPE")
    private IssueType type;
    @Column(name="TITLE")
    private String title;
    @Column(name="TICKET_ID")
    private String ticketId;
    @Column(name="STATUS")
    private String status;
    @Column(name="SEVERITY")
    private IssueSeverity severity;
    @Column(name="INFO_TYPE")
    private InfoType infoType;
    @Column(name="LINK")
    private String link;
    @Column(name="TOPIC_ASSIGNEE")
    private String assignee;
    @ManyToOne
    @JoinColumn(name="SPACE_ID")
    private SpaceEntity space;
    @ManyToOne
    @JoinColumn(name="ENVIRONMENT_ID")
    private EnvironmentEntity environment;
    @OneToMany(mappedBy="topic", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<LogEntity> logs;
    @Column(name="CREATIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate;
    @Column(name="UPDATEDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar updateDate;
    @Column(name="CREATOR")
    private String creator;

    public String getId() {
        return this.id;
    }

    public IssueType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public String getStatus() {
        return this.status;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public String getLink() {
        return this.link;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public SpaceEntity getSpace() {
        return this.space;
    }

    public EnvironmentEntity getEnvironment() {
        return this.environment;
    }

    public List<LogEntity> getLogs() {
        return this.logs;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSeverity(IssueSeverity severity) {
        this.severity = severity;
    }

    public void setInfoType(InfoType infoType) {
        this.infoType = infoType;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setSpace(SpaceEntity space) {
        this.space = space;
    }

    public void setEnvironment(EnvironmentEntity environment) {
        this.environment = environment;
    }

    public void setLogs(List<LogEntity> logs) {
        this.logs = logs;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicEntity)) {
            return false;
        }
        TopicEntity other = (TopicEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IssueType this$type = this.getType();
        IssueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$ticketId = this.getTicketId();
        String other$ticketId = other.getTicketId();
        if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        IssueSeverity this$severity = this.getSeverity();
        IssueSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        InfoType this$infoType = this.getInfoType();
        InfoType other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !((Object)((Object)this$infoType)).equals((Object)other$infoType)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        SpaceEntity this$space = this.getSpace();
        SpaceEntity other$space = other.getSpace();
        if (this$space == null ? other$space != null : !((Object)this$space).equals(other$space)) {
            return false;
        }
        EnvironmentEntity this$environment = this.getEnvironment();
        EnvironmentEntity other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        List<LogEntity> this$logs = this.getLogs();
        List<LogEntity> other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        Calendar this$creationDate = this.getCreationDate();
        Calendar other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        Calendar this$updateDate = this.getUpdateDate();
        Calendar other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        return !(this$creator == null ? other$creator != null : !this$creator.equals(other$creator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IssueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $ticketId = this.getTicketId();
        result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        IssueSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        InfoType $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : ((Object)((Object)$infoType)).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        SpaceEntity $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : ((Object)$space).hashCode());
        EnvironmentEntity $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        List<LogEntity> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        Calendar $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        Calendar $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        return result;
    }

    public String toString() {
        return "TopicEntity(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", title=" + this.getTitle() + ", ticketId=" + this.getTicketId() + ", status=" + this.getStatus() + ", severity=" + (Object)((Object)this.getSeverity()) + ", infoType=" + (Object)((Object)this.getInfoType()) + ", link=" + this.getLink() + ", assignee=" + this.getAssignee() + ", space=" + this.getSpace() + ", environment=" + this.getEnvironment() + ", logs=" + this.getLogs() + ", creationDate=" + this.getCreationDate() + ", updateDate=" + this.getUpdateDate() + ", creator=" + this.getCreator() + ")";
    }
}

