/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.security.Group;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;

public class CSSpaceApplicationHandler
extends DefaultSpaceApplicationHandler {
    private static final String CS_PARENT_NAV_NAME = "cs";
    public static final String NAME = "CSSpace";
    private UserPortalConfigService portalConfigService;
    private SpaceService spaceService;

    public CSSpaceApplicationHandler(InitParams params, SpaceTemplateService spaceTemplateService, DataStorage dataStorage, PageService pageService, UserPortalConfigService portalConfigService, SpaceService spaceService) {
        super(params, dataStorage, pageService, spaceTemplateService);
        this.portalConfigService = portalConfigService;
        this.spaceService = spaceService;
    }

    public void initApps(Space space, SpaceTemplate spaceTemplate) throws SpaceException {
        try {
            if (spaceTemplate == null) {
                throw new IllegalStateException("CS Space config is null");
            }
            super.initApps(space, spaceTemplate);
            this.createSpecificSiteLayoutAndNav(space);
            List spaceApplications = spaceTemplate.getSpaceApplicationList();
            for (SpaceApplication spaceApplication : spaceApplications) {
                this.spaceService.installApplication(space, spaceApplication.getPortletName());
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    public String getName() {
        return NAME;
    }

    private void createSpecificSiteLayoutAndNav(Space space) throws Exception {
        this.portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId(), NAME);
        SiteKey siteKey = SiteKey.group((String)space.getGroupId());
        PortalRequest portalRequest = PortalRequest.getInstance();
        if (portalRequest == null) {
            return;
        }
        Portal portal = portalRequest.getPortal();
        Group group = new Group(space.getGroupId());
        Site groupSpace = portal.getSite(new SiteId(group));
        Navigation navigation = portal.getNavigation(groupSpace.getId());
        Node home = navigation.getNode(NodePath.path((String[])new String[]{space.getUrl()}), Nodes.visitAll());
        Node tempHome = navigation.getNode(NodePath.path((String[])new String[]{CS_PARENT_NAV_NAME}), Nodes.visitAll());
        for (Node childNode : tempHome) {
            Node newNode = home.addChild(childNode.getName());
            newNode.setIconName(childNode.getIconName());
            newNode.setPageId(childNode.getPageId());
            newNode.setVisibility(childNode.getVisibility());
            navigation.saveNode(home);
            navigation.removeNode(childNode.getNodePath());
            this.convertChildApplicationPreferences(space, siteKey, newNode);
        }
        home.setPageId(tempHome.getPageId());
        navigation.saveNode(home);
        this.convertChildApplicationPreferences(space, siteKey, home);
        navigation.removeNode(tempHome.getNodePath());
    }

    private void convertChildApplicationPreferences(Space space, SiteKey siteKey, Node newNode) throws Exception {
        PageKey pageKey = new PageKey(siteKey, newNode.getPageId().getPageName());
        Page newPage = PageUtils.getPage((DataStorage)this.portalConfigService.getDataStorage(), (PageService)this.portalConfigService.getPageService(), (PageKey)pageKey);
        ArrayList modelObjects = newPage.getChildren();
        SpacePageUtils.convert(modelObjects, space.getGroupId());
    }
}

