/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.rest.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.rest.model.CSEnvironment;
import org.exoplatform.cs.rest.model.CSpace;
import org.exoplatform.cs.rest.model.Ticket;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.service.TaskService;

public class EntityBuilder {
    private static SimpleDateFormat simpleCreatedTicketDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static SimpleDateFormat simpleUpdateEnvDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);

    public static final Ticket fromTicketDto(TicketDTO ticketDTO) {
        Ticket ticket = new Ticket(ticketDTO.getId(), ticketDTO.getTitle(), ticketDTO.getStatus(), ticketDTO.getDescription(), ticketDTO.getLink(), ticketDTO.getAssignee(), ticketDTO.getAssigneeAvatar(), ticketDTO.getTagName(), ticketDTO.getType(), ticketDTO.getSeverity(), ticketDTO.getInfoType(), ticketDTO.getSpaceGroupId(), ticketDTO.getEnvironmentName(), ticketDTO.getEnvironmentId(), EntityBuilder.fromCalendar(ticketDTO.getStartDate().getTime(), simpleCreatedTicketDateFormat), ticketDTO.getFlow(), ticketDTO.getTicketId(), ticketDTO.getCreator(), ticketDTO.getCreatorId(), ticketDTO.getCreatorAvatar(), ticketDTO.getOwner(), ticketDTO.getAttachedJira(), ticketDTO.getWarning(), ticketDTO.getJiraStatus(), ticketDTO.getJiraStatusIcon(), ticketDTO.getTimeToFirstResponse(), ticketDTO.getTimeToResolution(), ticketDTO.getCustomerSatisfied(), ticketDTO.getInternal(), ticketDTO.getActive(), ticketDTO.getReason(), ticketDTO.getRateReason(), ticketDTO.getUploads(), EntityBuilder.getTicketTypes(), EntityBuilder.getOwnersList(), EntityBuilder.getSeverities(ticketDTO.getType()), EntityBuilder.getTicketAttachedTasksStatus(ticketDTO.getAttachedJira()));
        if (ticketDTO.getEndDate() != null) {
            ticket.setEndDate(EntityBuilder.fromCalendar(ticketDTO.getEndDate().getTime(), simpleDateFormat));
        }
        if (ticketDTO.getUpdateDate() != null) {
            ticket.setUpdateDate(EntityBuilder.fromCalendar(ticketDTO.getUpdateDate().getTime(), simpleDateFormat));
        }
        if (ticketDTO.getFirstWarningDate() != null) {
            ticket.setFirstWarningDate(EntityBuilder.fromCalendar(ticketDTO.getFirstWarningDate().getTime(), simpleDateFormat));
        }
        if (ticketDTO.getLastWarningDate() != null) {
            ticket.setLastWarningDate(EntityBuilder.fromCalendar(ticketDTO.getLastWarningDate().getTime(), simpleDateFormat));
        }
        if (ticketDTO.getAutoAssignDate() != null) {
            ticket.setAutoAssignDate(EntityBuilder.fromCalendar(ticketDTO.getAutoAssignDate().getTime(), simpleDateFormat));
        }
        return ticket;
    }

    public static final TicketDTO toTicketDto(Ticket ticket) throws ParseException {
        TicketDTO ticketDTO = new TicketDTO();
        ticketDTO.setId(ticket.getId());
        ticketDTO.setTitle(ticket.getTitle());
        ticketDTO.setStatus(ticket.getStatus());
        ticketDTO.setDescription(ticket.getDescription());
        ticketDTO.setLink(ticket.getLink());
        ticketDTO.setAssignee(ticket.getAssignee());
        ticketDTO.setTagName(ticket.getTagName());
        ticketDTO.setType(ticket.getType());
        ticketDTO.setInfoType(ticket.getInfoType());
        ticketDTO.setSpaceGroupId(ticket.getSpaceGroupId());
        ticketDTO.setEnvironmentName(ticket.getEnvironmentName());
        ticketDTO.setEnvironmentId(ticket.getEnvironmentId());
        ticketDTO.setFlow(ticket.getFlow());
        ticketDTO.setTicketId(ticket.getTicketId());
        ticketDTO.setCreator(ticket.getCreator());
        ticketDTO.setOwner(ticket.getOwner());
        ticketDTO.setSeverity(ticket.getSeverity());
        ticketDTO.setStartDate(EntityBuilder.toCalendar(ticket.getStartDate(), simpleCreatedTicketDateFormat));
        ticketDTO.setAttachedJira(ticket.getAttachedJira());
        ticketDTO.setWarning(ticket.getWarning());
        ticketDTO.setJiraStatus(ticket.getJiraStatus());
        ticketDTO.setJiraStatusIcon(ticket.getJiraStatusIcon());
        ticketDTO.setTimeToFirstResponse(ticket.getTimeToFirstResponse());
        ticketDTO.setTimeToResolution(ticket.getTimeToResolution());
        ticketDTO.setCustomerSatisfied(ticket.getCustomerSatisfied());
        ticketDTO.setInternal(ticket.getInternal());
        ticketDTO.setActive(ticket.getActive());
        ticketDTO.setReason(ticket.getReason());
        ticketDTO.setRateReason(ticket.getRateReason());
        ticketDTO.setUploads(ticket.getUploads());
        ticketDTO.setAttachments(ticket.getAttachments());
        return ticketDTO;
    }

    public static final CSEnvironment fromEnvironmentDto(EnvironmentDTO environmentDTO) {
        return new CSEnvironment(environmentDTO.getId(), environmentDTO.getName(), environmentDTO.getSpaceGroupId(), environmentDTO.isDefaultEnvironment(), environmentDTO.getTypeId(), environmentDTO.getTypeName(), environmentDTO.getTypeOtherId(), environmentDTO.getTypeOtherName(), environmentDTO.getProductVersion(), environmentDTO.getOsId(), environmentDTO.getOsName(), environmentDTO.getOsOtherId(), environmentDTO.getOsOtherName(), environmentDTO.getOsVersion(), environmentDTO.getJvmVendorId(), environmentDTO.getJvmVendorName(), environmentDTO.getJvmVendorOtherId(), environmentDTO.getJvmVendorOtherName(), environmentDTO.getJvmVersion(), environmentDTO.getAsId(), environmentDTO.getAsName(), environmentDTO.getAsOtherId(), environmentDTO.getAsOtherName(), environmentDTO.getAsVersion(), environmentDTO.getDbId(), environmentDTO.getDbName(), environmentDTO.getDbOtherId(), environmentDTO.getDbOtherName(), environmentDTO.getDbVersion(), environmentDTO.getDbEncoding(), environmentDTO.getSsoId(), environmentDTO.getSsoName(), environmentDTO.getSsoOtherId(), environmentDTO.getSsoOtherName(), environmentDTO.getSsoVersion(), environmentDTO.getMoreInformation(), environmentDTO.getBrowsers(), EntityBuilder.fromCalendar(environmentDTO.getUpdateDate().getTime(), simpleUpdateEnvDateFormat), environmentDTO.getCustomerExtensionVersion(), environmentDTO.getInstalledPatchVersion());
    }

    public static final CSpace fromSpaceDto(SpaceDTO spaceDTO) {
        return new CSpace(spaceDTO.getName(), spaceDTO.getDescription(), spaceDTO.getGroupId(), spaceDTO.getUrl(), spaceDTO.getTaskDefaultAssignee(), spaceDTO.getTagPrefix(), spaceDTO.getManagersGroupId(), spaceDTO.getInvitedMembersGroupId(), spaceDTO.getMembers(), spaceDTO.getTagIndex(), spaceDTO.getTaskPriority(), spaceDTO.getOwner(), spaceDTO.getLimitTicketsNumber(), spaceDTO.getSupportTickets(), spaceDTO.getActifTickets(), spaceDTO.getProductTickets(), spaceDTO.getTotalTickets(), spaceDTO.getIncidentFlow(), spaceDTO.getInformationFlow(), spaceDTO.getLanguage(), spaceDTO.isHosted(), spaceDTO.getSla(), spaceDTO.getSubscription(), spaceDTO.getSubscriptionStartDate(), spaceDTO.getSubscriptionEndDate(), spaceDTO.isSubscriptionActive(), spaceDTO.isInternal(), spaceDTO.getCustomerExtensionVersion(), spaceDTO.getInstalledPatchVersion(), "");
    }

    private static List<String> getSeverities(IssueType ticketType) {
        ArrayList<String> severities = new ArrayList<String>();
        if (ticketType.equals((Object)IssueType.INCIDENT)) {
            severities.add(IssueSeverity.SEVERITY_1.name());
            severities.add(IssueSeverity.SEVERITY_2.name());
            severities.add(IssueSeverity.SEVERITY_3.name());
        } else if (ticketType.equals((Object)IssueType.INFORMATION)) {
            severities.add(IssueSeverity.SEVERITY_4.name());
        }
        return severities;
    }

    private static List<String> getTicketTypes() {
        ArrayList<String> ticketTypes = new ArrayList<String>();
        ticketTypes.add(IssueType.INCIDENT.name());
        ticketTypes.add(IssueType.INFORMATION.name());
        return ticketTypes;
    }

    private static List<String> getOwnersList() {
        ArrayList<String> ownersList = new ArrayList<String>();
        Owner[] owners = Owner.values();
        for (int i = 0; i < owners.length; ++i) {
            ownersList.add(owners[i].name());
        }
        return ownersList;
    }

    private static String fromCalendar(Date date, SimpleDateFormat simpleDateFormat) {
        return simpleDateFormat.format(date);
    }

    private static Calendar toCalendar(String date, SimpleDateFormat simpleDateFormat) throws ParseException {
        Date calendarDate = simpleDateFormat.parse(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(calendarDate);
        return calendar;
    }

    private static Map<String, String> getTicketAttachedTasksStatus(String tasks) {
        HashMap<String, String> result = new HashMap<String, String>();
        TaskService taskService = (TaskService)CommonsUtils.getService(TaskService.class);
        if (StringUtils.isNotBlank((CharSequence)tasks)) {
            Arrays.stream(tasks.split("\\s+")).filter(taskId -> StringUtils.isNumeric((CharSequence)taskId)).mapToLong(Long::parseLong).forEach(taskId -> {
                String status = "";
                try {
                    status = taskService.getTask(taskId).getStatus().getName();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Could not get ticket attached task status");
                }
                result.put(Long.toString(taskId), status);
            });
        }
        return result;
    }
}

