define("supportControllers", [ "SHARED/jquery", "SHARED/juzu-ajax"], function(
    $) {
  var csCtrl = function($scope, $q, $timeout, $http, $filter) {
    var csContainer = $('#csAddon');
    var deferred = $q.defer();

    $scope.tickets = [];
    $scope.validateForm = false;
    $scope.currentPage = 0;
    $scope.pageSize = 10;
    $scope.def = '';

    $scope.orderByField = 'title';
    $scope.reverseSort = false;

    $scope.newField = {};
    $scope.editing = false;
    $scope.ticketEdit = {};


    $scope.setResultMessage = function(text, type) {
      $scope.resultMessageClass = "alert-" + type;
      $scope.resultMessageClassExt = "uiIcon" + type.charAt(0).toUpperCase()
          + type.slice(1);
      $scope.resultMessage = text;
    }

    $scope.pageSizes = [{value: "5"},{value: "10"},{value: "15"},{value: "30"},{value: "60"},{value: "100"}];
    $scope.loadBundles = function() {
      $http({
        method : 'GET',
        url : csContainer.jzURL('SupportViewController.getBundle') + "&locale=" + eXo.env.portal.language
      }).then(function successCallback(data) {
        $scope.i18n = data.data;
        deferred.resolve(data);
      }, function errorCallback(data) {
        $scope.setResultMessage(data, "error");
      });
    }

    $scope.loadTickets = function() {
      $http({
        method : 'GET',
        url : csContainer.jzURL('SupportViewController.getAllTickets')
      }).then(function successCallback(data) {
        $scope.setResultMessage(data, "success");
        $scope.tickets = data.data;

        $timeout(function() {
          $scope.setResultMessage("", "info")
        }, 3000);
      }, function errorCallback(data) {
        $scope.setResultMessage(data, "error");
      });

      return $filter('filter')($scope.tickets, $scope.def)
    };

    $scope.numberOfPages=function(){
       return Math.ceil($scope.tickets.length/$scope.pageSize);
     }

    $scope.loadTickets();
    $scope.loadBundles();
    $('#csAddon').css('visibility', 'visible');
    $(".csLoadingBar").remove();
  };
  return csCtrl;
});