define("ticketControllers",
    [ "SHARED/jquery", "SHARED/uiCalendar", "SHARED/CalDateTimePicker",
        "SHARED/DateTimeFormatter", "SHARED/juzu-ajax", "/commons-extension/ckeditor/ckeditor.js" ], function($,
        timePicker, otherTimePicker, dateFormatter, jz) {
      var ticketCtrl = function($scope, $q, $timeout, $http, $filter, $window) {
        var ticketContainer = $('#ticketAddon');
        var deferred = $q.defer();

        $scope.environments = [];
        $scope.newTicket = {};
        $scope.fileUploading = false;
        $scope.locale = eXo.env.portal.language;
        $scope.dateFormat = dateFormatter.masks["isoDate"].replace("mm", "MM")
            + " HH:mm";
        $scope.dateInputFields = [];

        $scope.initForm = function() {
          $scope.newTicket = {};
          $scope.newTicket.environmentId = "" + ($filter('filter')($scope.environments, {defaultEnvironment:true}).length > 0 ? $filter('filter')($scope.environments, {defaultEnvironment:true})[0].id : null);
          $scope.resultMessage='';
          $scope.ticketLink = null;
          $scope.importFiles = null;
          $scope.newTicketForm = null;
          var severity = $scope.getParameterByName('severity');
          var ticketType = $scope.getParameterByName('ticketType');
          if(severity && severity.length > 0){
            $scope.newTicket.severity = severity;
          }
          if(ticketType && ticketType.length > 0){
            $scope.newTicket.type = ticketType;
          }

        }

        $scope.loadBundles = function() {
          $http({
            method : 'GET',
            url : ticketContainer.jzURL('TicketController.getBundle') + "&locale=" + eXo.env.portal.language
          }).then(function successCallback(data) {
            $scope.i18n = data.data;
            deferred.resolve(data);
          }, function errorCallback(data) {
            $scope.setResultMessage($scope.i18n.errorInitForm, "error");
          });
        }

        $scope.newEnvironmentForm = function() {
          var locationHref = window.location.href;
          var relativePath = locationHref.replace(/^(?:\/\/|[^\/]+)*\//, "/");
          var indexOfSemiColon = locationHref.lastIndexOf(":spaces:");
          var indexOfSlash = locationHref.indexOf("/", indexOfSemiColon+1);
          if(indexOfSlash <0) indexOfSlash =  locationHref.length
          var spacePrettyName = eXo.env.portal.selectedNodeUri;
          var indexSlashPrettyName = spacePrettyName.indexOf('/');
          if(indexSlashPrettyName > 0) {
            spacePrettyName = spacePrettyName.substring(0, indexSlashPrettyName);
          }
          var environmentLink = locationHref.substring(0, indexOfSlash) + "/" + spacePrettyName + "/environments?new=true&initURL="
          +encodeURIComponent(relativePath)+"&ticketType="+$scope.newTicket.type+"&severity="+$scope.newTicket.severity;
          window.location.href = environmentLink;
        };

        $scope.loadEnvironments = function() {
          $http({
            method : 'GET',
            url : ticketContainer.jzURL('TicketController.getEnvironments')
          }).then(function successCallback(data) {
            $scope.environments = data.data;
            $scope.initForm();
          }, function errorCallback(data) {
            $scope.setResultMessage($scope.i18n.errorInitForm, "error");
          });
        };

        $scope.saveTicket = function() {
          $scope.newTicket.description = CKEDITOR.instances.requestDescription.getData();
          if ($scope.newTicket.description.replace('/<[^>]*>/gi', '').length == 0){
             $scope.setCKEditorError($scope.i18n.validateAddDescription,'error');
             return;
          } else {
             $scope.setCKEditorError('','');
          }
          if($scope.newTicket.type == 'PRODUCT'){
            var validateDateMsg = '', startAfterEndDateMsg= '';
             validateDateMsg = $scope.validateDate($scope.newTicket.startDate);
            if (validateDateMsg && validateDateMsg.length > 0){
               $scope.setStartDateError(validateDateMsg,'error');
               return;
            } else {
               $scope.setStartDateError('','');
            }
            validateDateMsg = $scope.validateDate($scope.newTicket.endDate);
            if (validateDateMsg && validateDateMsg.length > 0){
               $scope.setEndDateError(validateDateMsg,'error');
               return;
            }else {
               $scope.setEndDateError('','');
            }
            var startAfterEndDateMsg = $scope.validateEndDate($scope.newTicket.startDate,$scope.newTicket.endDate);
             if (startAfterEndDateMsg && startAfterEndDateMsg.length > 0){
               $scope.setStartAfterEndDateError(startAfterEndDateMsg,'error');
               return;
            } else {
               $scope.setStartAfterEndDateError('','');
            }
            $scope.newTicket.dateFormat = $scope.dateFormat;
          }
          //Append the description field with the Information type
          if($scope.newTicket.type == 'INFORMATION'){
            var descriptionTitle = "<blockquote><b>" + $scope.i18n['request'+$scope.newTicket.infoType+'Prefix'] + ": </b>" + $scope.i18n['request'+$scope.newTicket.infoType] + "</blockquote>";
            $scope.newTicket.description = descriptionTitle + $scope.newTicket.description;
          }

          $scope.setResultMessage($scope.i18n.savingTicket, "info");
          $http({
            data : $scope.newTicket,
            method : 'POST',
            headers : {
              'Content-Type' : 'application/json'
            },
            url : ticketContainer.jzURL('TicketController.saveTicket')
          }).then(function successCallback(data) {
            if (data && data.data && data.data.length > 0 && data.data.indexOf("/") == 0) {
              $scope.ticketLink = data.data;
            } else {
              $scope.ticketLink = null;
            }
            if($scope.newTicket.type == 'PRODUCT'){
               $scope.setResultMessage($scope.i18n.productQuestionSubmitted, "success");
               $scope.ticketLink = null;
            } else {
               $scope.setResultMessage($scope.i18n.ticketSubmitted, "success");
            }
            $scope.newTicket = null;
            $scope.newTicketForm = null;
            for(instance in CKEDITOR.instances ){
              CKEDITOR.instances[instance].updateElement();
              CKEDITOR.instances[instance].setData('');
            }
          }, function errorCallback(data) {
            $scope.setResultMessage($scope.i18n.ticketSubmitionError, "error");
          });
          $window.scrollTo(0, 0);
        }

        // function which set the result message with the given style
        $scope.setResultMessage = function(text, type) {
          $scope.resultMessageClass = "alert-" + type;
          $scope.resultMessageClassExt = "uiIcon"
              + type.charAt(0).toUpperCase() + type.slice(1);
          $scope.resultMessage = text;
        }

        $scope.setCKEditorError = function(text, type) {
          $scope.ckeditorErrorClass = "error";
          $scope.ckeditorErrorMessage = text;
        }
        $scope.setStartDateError = function(text, type) {
          $scope.startDateErrorClass = "error";
          $scope.startDateErrorMessage = text;
        }
        $scope.setEndDateError = function(text, type) {
          $scope.endDateErrorClass = "error";
          $scope.endDateErrorMessage = text;
        }
        $scope.setStartAfterEndDateError = function(text, type) {
          $scope.StartAfterEndDateErrorClass = "error";
          $scope.StartAfterEndDateErrorMessage = text;
        }

        $scope.fileUploadClick = function(element) {
          $scope.$apply(function($scope) {
            $(".ticketAddon input#fileToImport").click();
          });
        };

        $scope.prepareImportFile = function(element) {
          $scope.importFiles = element.files;
          if (!$scope.importFiles || !$scope.importFiles.length) {
            $scope.importFiles = null;
            $scope.setResultMessage($scope.i18n.noSelectedFile, "error");
            return;
          }

          $(".ticketAddon .uiAction").addClass("resources-loader");

          console.log("length = " + $scope.importFiles.length);
          if($scope.importFiles.length > 3) {
            $scope.importFiles = null;
            $scope.setResultMessage($scope.i18n.validateMaxSelectedFile, "warning");
            return;
          }
          var form = new FormData();
          for (i = 1; i <= $scope.importFiles.length; i++){
            var importFile = $scope.importFiles[i - 1];
            console.log("importFile = " + importFile);
            console.log("name = " + importFile.name);
            console.log("size = " + importFile.size);
            if(importFile.size > 10485760) {
              $scope.importFiles = null;
              $scope.setResultMessage($scope.i18n.validateMaxSelectedFileSize, "warning");
              return;
            }
            form.append("file" + i, importFile);
          }

          $scope.fileUploading = true;
          $scope.setResultMessage($scope.i18n.analyzingFile, "info");
          $http({
            url : ticketContainer.jzURL("TicketController.prepareImportFile"),
            data : form,
            method : 'POST',
            headers : {
              'Content-Type' : undefined
            },
            transformRequest : function(data) {
              return data;
            }
          }).success(function(dataList) {
            $scope.fileUploading = false;
            $scope.setResultMessage("", "info");

            $(".ticketAddon .uiAction").removeClass("resources-loader");
          }).error(function(data) {
            $scope.fileUploading = false;
            $scope.importFiles = null;
            $(".ticketAddon .uiAction").removeClass("resources-loader");
            $scope.setResultMessage($scope.i18n.errorUploadingFile, "error");
          });
        }

        $scope.validateDate = function(txtDate) {
          if (!txtDate) {
            return $scope.i18n.validateAddStartDate;
          }
          if (isNaN(Date.parse(txtDate))) {
            return $scope.i18n.validateStartDateFormat;
          }
        };
        $scope.validateEndDate = function(start,end){
        if (Date.parse(end) <= Date.parse(start)) {
            return $scope.i18n.validateEndAfterStartDates;
          }
        }

        $scope.setDateTimeField = function(inputFieldId) {
          $scope.dateInputFields[$scope.dateInputFields.length] = inputFieldId;
          timePicker.isDisplayTime = true;
          $("#" + inputFieldId).on("change", function(evt) {
            $scope.newTicket[evt.target.id] = evt.target.value;
          });
          timePicker.hideCalendarHandler = function(evt) {
            $scope.refreshController();
            console.log(evt.srcElement.value);
            if (evt.type == "click"
                && $scope.dateInputFields.indexOf(evt.srcElement.id) >= 0) {
              return;
            }
            timePicker.hide();
          }
          $("#" + inputFieldId).focus(
              function() {
                otherTimePicker.isDisplayTime = true;
                timePicker.init(document.getElementById(inputFieldId), true,
                    $scope.dateFormat, "", otherTimePicker.months.toString());
              });
          $("#" + inputFieldId).keyup(function() {
            eXo.webui.UICalendar.show();
          });
          $("#" + inputFieldId).focus(function(event) {
            event.cancelBubble = true;
          });
        }

        $scope.getParameterByName = function (name, url) {
           if (!url) {
             url = window.location.href;
           }
           name = name.replace(/[\[\]]/g, "\\$&");
           var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
               results = regex.exec(url);
           if (!results) return null;
           if (!results[2]) return '';
           return decodeURIComponent(results[2].replace(/\+/g, " "));
        }



        $scope.loadEnvironments();
        $scope.loadBundles();
        $scope.setDateTimeField("startDate");
        $scope.setDateTimeField("endDate");

        CKEDITOR
            .replace(
                'requestDescription',
                {
                  toolbar:'Basic',
                  height : '200px',
                  contentsCss : ['/commons-extension/ckeditor/contents.css'],
                  enterMode : CKEDITOR.ENTER_P,
                  forceEnterMode : false,
                  shiftEnterMode : CKEDITOR.ENTER_BR
                });

        $scope.refreshController = function() {
          try {
            $scope.$apply();
            $scope.$digest();
          } catch (excep) {
            // Nothing here
          }
        };

        $('#ticketAddon').css('visibility', 'visible');
        $(".ticketLoadingBar").remove();
      };
      return ticketCtrl;
    });