define("ticketAdminControllers", [ "SHARED/jquery", "SHARED/juzu-ajax"], function($) {
  var csCtrl = function($scope, $q, $timeout, $http, $filter, PagerService) {
    var csContainer = $('#csAddon');
    var deferred = $q.defer();

    $scope.tickets = [];
    $scope.assignees = [];
    $scope.currentPage = 0;
    $scope.pageSize = 10;
    $scope.def = '';

    $scope.orderByField = 'title';
    $scope.reverseSort = false;
    $scope.assignee = {};
    $scope.ticket = {};

    $scope.vm = this;
    $scope.vm.pager = {};
    $scope.vm.setPage = setPage;

    $scope.initController = function() {
      // initialize to page 1
      $scope.vm.setPage(1);
    }

    function setPage(page) {
      if (page < 1 || page > $scope.vm.pager.totalPages) {
          return;
      }

      // get pager object from service
      $scope.vm.pager = PagerService.GetPager($scope.tickets.length, page);

      // get current page of items
      $scope.vm.items = $scope.tickets.slice($scope.vm.pager.startIndex, $scope.vm.pager.endIndex + 1);
    }

    $scope.setResultMessage = function(text, type) {
      $scope.resultMessageClass = "alert-" + type;
      $scope.resultMessageClassExt = "uiIcon" + type.charAt(0).toUpperCase()
          + type.slice(1);
      $scope.resultMessage = text;
    }

    $scope.pageSizes = [{value: "5"},{value: "10"},{value: "15"},{value: "30"},{value: "60"},{value: "100"}];
    $scope.loadBundles = function() {
      $http({
        method : 'GET',
        url : csContainer.jzURL('TicketAdministrationController.getBundle') + "&locale=" + eXo.env.portal.language
      }).then(function successCallback(data) {
        $scope.i18n = data.data;
        deferred.resolve(data);
      }, function errorCallback(data) {
        $scope.setResultMessage(data, "error");
      });
    }

    $scope.loadTickets = function() {
      $http({
        method : 'GET',
        url : csContainer.jzURL('TicketAdministrationController.getAllTickets')
      }).then(function successCallback(data) {
        $scope.setResultMessage(data, "success");
        $scope.tickets = data.data;
        $scope.vm.items = $scope.tickets;
        $scope.vm.setPage(1);
        $timeout(function() {
          $scope.setResultMessage("", "info")
        }, 3000);
      }, function errorCallback(data) {
        $scope.setResultMessage(data, "error");
      });

      return $filter('filter')($scope.tickets, $scope.def)
    };

    $scope.numberOfPages=function(){
       return Math.ceil($scope.tickets.length/$scope.pageSize);
    }



    $scope.editTicket = function(modifiedTicket){
       $scope.ticket = modifiedTicket;
       $scope.loadAssignees($scope.ticket);
    }

    $scope.showSelectValue = function(assignee) {
       $scope.assignee = assignee;
    }

    $scope.saveTicket = function(ticket) {
       ticket.assignee = $scope.assignee;
       $http({
          data : ticket,
          method : 'POST',
          headers : {
             'Content-Type' : 'application/json'
          },
          url : csContainer.jzURL('TicketAdministrationController.saveTicket')
       }).then(function successCallback(data) {
          ticket.id = data.data.id;
       }, function errorCallback(data) {
          $scope.setResultMessage($scope.i18n.ticketSubmitionError, "error");
       });
    }

    $scope.loadAssignees = function(ticket) {
       ticket = $scope.ticket;
       $http({
          data : ticket,
          method : 'POST',
          headers : {
            'Content-Type' : 'application/json'
          },
          url : csContainer.jzURL('TicketAdministrationController.getEngSupportsUsernames')
       }).then(function successCallback(data) {
           $scope.assignees = data.data;
           $timeout(function() {
                $scope.setResultMessage("", "info")
           }, 3000);
       },function errorCallback(data) {
           $scope.setResultMessage(data, "error");
       });
    }

    $scope.loadTickets();
    $scope.loadBundles();
    $('#csAddon').css('visibility', 'visible');
    $(".csLoadingBar").remove();
  };
  return csCtrl;
});