/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.entity;

import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Priority;

import javax.persistence.*;
import java.util.Calendar;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Entity(name = "CSSpaceEntity")
@ExoEntity
@Table(name = "CS_ADDON_SPACES")
@NamedQueries({
  @NamedQuery(name = "spaceEntity.findAllOrderBy", query = "SELECT a FROM CSSpaceEntity a order by a.groupId asc"),
  @NamedQuery(name = "spaceEntity.count", query = "SELECT count(a.groupId) FROM CSSpaceEntity a") })
@Data
public class SpaceEntity {

  @Id
  @Column(name = "SPACE_ID")
  private String groupId;

  @Column(name = "TASK_DEFAULT_ASSIGNEE", nullable = false)
  private String taskDefaultAssignee;

  @Column(name = "TASK_PRIORITY", nullable = false)
  private Priority   taskPriority;

  @Column(name = "TAG_PREFIX", nullable = false)
  private String tagPrefix;

  @Column(name = "TAG_INDEX", nullable = false)
  private long   tagIndex = 1;

  @Column(name = "MANAGERS_GROUP_ID")
  private String managersGroupId;

  @Column(name = "INVITED_MEMBERS_GROUP_ID")
  private String invitedMembersGroupId;

  @Column(name = "TICKET_LIMIT")
  private long   limitTicketsNumber;

  @Column(name = "HOSTED",nullable = false)
  private boolean hosted;

  @Column(name = "INFORMATION_FLOW")
  private String informationFlow;

  @Column(name = "INCIDENT_FLOW")
  private String incidentFlow;

  @Column(name = "LANG")
  private String language;

  @Column(name = "SLA")
  private String sla;

  @Column(name = "SUBSCRIPTION")
  private String subscription;

  @Column(name = "SUBSCRIPTION_START_DATE")
  @Temporal(TemporalType.TIMESTAMP)
  private Calendar subscriptionStartDate;

  @Column(name = " SUBSCRIPTION_END_DATE")
  @Temporal(TemporalType.TIMESTAMP)
  private Calendar subscriptionEndDate;

  @Column(name = "SUBSCRIPTION_ACTIVE")
  private boolean subscriptionActive;


}
