package org.exoplatform.cs.service.subscription;

import org.exoplatform.container.component.ComponentPlugin;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picocontainer.Startable;

import java.util.ArrayList;
import java.util.List;

public class SubscriptionService implements Startable{

  private static final Logger LOG = LoggerFactory.getLogger(SubscriptionService.class);


  private List<Subscription> subscriptions = new ArrayList<>();

  public SubscriptionService() {

  }


  public void addSubscription(ComponentPlugin subscriptionPlugin){
    if(subscriptionPlugin instanceof SubscriptionPlugin){
      SubscriptionConfig config = ((SubscriptionPlugin) subscriptionPlugin).getSubscriptionConfig();
       if(config != null) {
         subscriptions.add(config.getSubscription());
       }
    }
  }



  @Override
  public void start() {

  }

  @Override
  public void stop() {

  }
  public List<Subscription>  getSubscriptions() {
    return subscriptions;
  }
}


