package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;


import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSConstants;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.*;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;

import static org.exoplatform.cs.service.CSConstants.STATUS_CLOSED;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 09/01/17
 * Time: 15:17
 */
public class TicketUpdatedLogListener extends Listener<TopicEntity, Map<String,String>> {
  private static final Log LOG = ExoLogger.getLogger(TicketUpdatedLogListener.class);
  private static final String STATUS_RB = "cs.ticket.status.";
  private static final String TICKET_STATUS_UPDATED_MESSAGE = "cs.ticket.status.updated";
  private static final String TICKET_TYPE_UPDATED_MESSAGE = "cs.ticket.type.updated";
  private static final String TICKET_SEVERITY_UPDATED_MESSAGE = "cs.ticket.severity.updated";
  private static final String TYPE_RB = "cs.ticket.type.";
  private static final String SEVERITY_RB = "cs.ticket.severity.";
  private LogDAO logDAO;
  private ForumService forumService;
  private ResourceBundleService resourceBundleService;
  
  public TicketUpdatedLogListener(LogDAO logDAO,ForumService forumService,ResourceBundleService resourceBundleService) {
    this.logDAO = logDAO;
    this.forumService = forumService;
    this.resourceBundleService = resourceBundleService;
  }

  @Override
  public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {

    ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.customer-space", Locale.getDefault());
    TopicEntity ticket = event.getSource();
    Map<String,String> data = event.getData();
    String userID = data.get(CSConstants.USERID);
    Calendar now = Calendar.getInstance();
    //StringBuilder sb = new StringBuilder();

    String oldAssignee = data.get(CSConstants.OLD_ASSIGNEE);
    String newAssignee = data.get(CSConstants.NEW_ASSIGNEE);
    if(oldAssignee != null && newAssignee != null){
      LOG.info("Assignee changed from {} to {}", oldAssignee, newAssignee);
      LogEntity logEntity = new LogEntity(LogType.TICKET_ASSIGNEE_CHANGED, userID, now,oldAssignee,newAssignee,ticket);
      logDAO.create(logEntity);
    }
    String oldType = data.get(CSConstants.OLD_TYPE);
    String newType = data.get(CSConstants.NEW_TYPE);
    if(oldType != null && newType != null){
      LOG.info("Type changed from {} to {}", oldType, newType);
      LogEntity logEntity = new LogEntity(LogType.TICKET_TYPE_CHANGED, userID, now,oldType,newType,ticket);
      logDAO.create(logEntity);
      //sb.append(replaceVarsInBundle(resourceBundle.getString(TICKET_TYPE_UPDATED_MESSAGE),resourceBundle.getString(TYPE_RB+oldType),resourceBundle.getString(TYPE_RB+newType)));
    }
    String oldSeverity = data.get(CSConstants.OLD_SEVERITY);
    String newSeverity = data.get(CSConstants.NEW_SEVERITY);
    if(oldSeverity != null && newSeverity != null){
      LOG.info("Severity changed from {} to {}", oldSeverity, newSeverity);
      LogEntity logEntity = new LogEntity(LogType.TICKET_SEVERITY_CHANGED, userID, now,oldSeverity,newSeverity,ticket);
      logDAO.create(logEntity);

      //sb.append(replaceVarsInBundle(resourceBundle.getString(TICKET_SEVERITY_UPDATED_MESSAGE),resourceBundle.getString(SEVERITY_RB+oldSeverity),resourceBundle.getString(SEVERITY_RB+newSeverity)));
    }
    String oldStatus = data.get(CSConstants.OLD_STATUS);
    String newStatus = data.get(CSConstants.NEW_STATUS);
    if(oldStatus != null && newStatus != null){
      LOG.info("Status changed from {} to {}", oldStatus, newStatus);
      LogEntity logEntity = new LogEntity(LogType.TICKET_SEVERITY_CHANGED, userID, now, oldStatus, newStatus, ticket);
      logDAO.create(logEntity);
      //sb.append(replaceVarsInBundle(resourceBundle.getString(TICKET_STATUS_UPDATED_MESSAGE),resourceBundle.getString(STATUS_RB+oldStatus),resourceBundle.getString(STATUS_RB+newStatus)));
      //if ticket is closed, close the topic too
      if (STATUS_CLOSED.equalsIgnoreCase(newStatus)){
        Topic topic = ForumUtils.getTopicByTicket(forumService,ticket);
        topic.setTopicName(CSConstants.RESOLVED_TAG + topic.getTopicName());
          topic.setModifiedBy(data.get(CSConstants.USERID));
          //topic.setIsClosed(true);
        forumService.saveTopic(topic.getCategoryId(),topic.getForumId(),topic,false,false,new MessageBuilder());
      }
      //if ticket is reopened, reopen the topic too
      if (STATUS_CLOSED.equalsIgnoreCase(oldStatus)){
        Topic topic = ForumUtils.getTopicByTicket(forumService,ticket);
        topic.setTopicName(topic.getTopicName().replace(CSConstants.RESOLVED_TAG,""));
        topic.setModifiedBy(data.get(CSConstants.USERID));
        //topic.setIsClosed(false);
        forumService.saveTopic(topic.getCategoryId(),topic.getForumId(),topic,false,false,new MessageBuilder());
      }


    }
//    if(!sb.toString().isEmpty()){
//      ForumUtils.postMessageToTicket(forumService, ticket,sb.toString());
//    }
  }

  private String replaceVarsInBundle(String bundle, String... strings){
    for(int i=0;i<strings.length;i++){
      bundle = bundle.replace("{"+i+"}",strings[i]);
    }
    return bundle;
  }
}
