package org.exoplatform.cs.job;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.StatLogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.integration.notification.CSReminderPlugin;
import org.exoplatform.cs.service.StatsService;
import org.exoplatform.cs.service.TicketService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;
import java.util.List;

/**
 * Created by eXo Platform SAS.
 *
 * @author Ali Hamdi 
 * @since 23/08/17 17:39
 */

public class ReminderNotificationJob implements Job {
  private static final Logger LOG = LoggerFactory.getLogger(ReminderNotificationJob.class);



  @Override
  public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
    ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
    TicketService ticketService = containerContext.getComponentInstanceOfType(TicketService.class);
    Calendar c = Calendar.getInstance();
    c.add(Calendar.DATE, -2);
    List<TopicEntity>  tickets = ticketService.findTicketsForReminder(c);
    for (TopicEntity ticket : tickets){
      String period= "";
      Calendar c1 = Calendar.getInstance();
      c1.add(Calendar.DATE, -7);
      Calendar c2 = Calendar.getInstance();
      c2.add(Calendar.DATE, -8);
      if(((Calendar)ticket.getUpdateDate()).before(c1)&& ((Calendar)ticket.getUpdateDate()).after(c2)){
        period = "7";
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, ticket).append(CSReminderPlugin.PERIOD, period);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(CSReminderPlugin.ID))).execute(ctx);
      }

      c1 = Calendar.getInstance();
      c1.add(Calendar.DATE, -3);
      c2 = Calendar.getInstance();
      c2.add(Calendar.DATE, -4);
      if(((Calendar)ticket.getUpdateDate()).before(c1)&& ((Calendar)ticket.getUpdateDate()).after(c2)){
        period = "3";
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, ticket).append(CSReminderPlugin.PERIOD, period);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(CSReminderPlugin.ID))).execute(ctx);
      }

      c1 = Calendar.getInstance();
      c1.add(Calendar.DATE, -2);
      c2 = Calendar.getInstance();
      c2.add(Calendar.DATE, -3);
      if(((Calendar)ticket.getUpdateDate()).before(c1)&& ((Calendar)ticket.getUpdateDate()).after(c2)){
        period = "2";
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSReminderPlugin.TICKET, ticket).append(CSReminderPlugin.PERIOD, period);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(CSReminderPlugin.ID))).execute(ctx);
      }

    }
    LOG.info("Reminder Notification Job finished");
  }

}
