import './initComponents.js';
const appId = 'CSTicketMenuApplication';

// get overrided components if exists
if (extensionRegistry) {
  const components = extensionRegistry.loadComponents('TicketMenu');
  if (components && components.length > 0) {
    components.forEach(cmp => {
      Vue.component(cmp.componentName, cmp.componentOptions);
    });
  }
}
Vue.use(Vuetify);
const vuetify = new Vuetify(eXo.env.portal.vuetifyPreset);
//getting language of the PLF
const lang = eXo && eXo.env.portal.language || 'en';
//should expose the locale ressources as REST API
const url = `${eXo.env.portal.context}/${eXo.env.portal.rest}/i18n/bundle/locale.portlet.customer_space-${lang}.json`;

export function init() {
  exoi18n.loadLanguageAsync(lang, url).then(i18n => {
    // init Vue app when locale ressources are ready
    new Vue({
      template: '<ticket-menu v-cacheable id="ticket-menu" />',
      vuetify,
      i18n
    }).$mount(`#${appId}`);
  });
}
