@Portlet
@Application(name = "TicketMenuController")
@Bindings({
        @Binding(value = TicketStatusFlowService.class),
        @Binding(value = TicketService.class),
        @Binding(value = EnvironmentService.class),
        @Binding(value = IdentityManager.class),
        @Binding(value = CSSpaceService.class)})
@Scripts({
    @Script(id = "jQueryUI", value = "js/lib/jquery-ui.js"),
    // AngularJS is still global, should be AMDified
    @Script(id = "angularjs", value = "js/lib/angular.min.js"),
    @Script(id = "ngSanitize", value = "js/lib/angular-sanitize.js", depends = "angularjs"),
    @Script(id = "ng-google-chart", value = "js/lib/ng-google-chart.js", depends = "angularjs"),
    // services and controllers js are AMD modules, required by controllers.js
    @Script(id = "controllers", value = "js/controllers.js", depends = { "angularjs" , "ng-google-chart"}),
    @Script(id = "ticketMenuAddon", value = "js/ticket-menu.js", depends = { "controllers","jQueryUI" }) })

@Stylesheets({
        @Stylesheet(id = "jQueryUISkin", value = "style/jquery-ui.css") ,
        @Stylesheet(id = "nps-menu", value = "style/ticket-menu.css") })

@Assets("*")
package org.exoplatform.cs.portlet.ticketMenu;

import juzu.Application;
import juzu.plugin.asset.Assets;
import juzu.plugin.asset.Script;
import juzu.plugin.asset.Scripts;
import juzu.plugin.asset.Stylesheet;
import juzu.plugin.asset.Stylesheets;
import juzu.plugin.binding.Binding;
import juzu.plugin.binding.Bindings;
import juzu.plugin.portlet.Portlet;


import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.social.core.manager.IdentityManager;


