const csTicketFeedbackPlugin = {
  key: 'support_ticket',
  rank: 40,
  resourceBundle: 'locale.portlet.customer_space',
  labelKey: 'cs.create.support.ticket',
  description: 'cs.create.support.ticket.description',
  iconClass: 'csComposerIcon',
  enabled: false,
  onExecute: function (attachments) {
    const url = `${eXo.env.portal.context}/g/:spaces:${eXo.env.portal.spaceGroup}/${eXo.env.portal.spaceName}/ticket`;
    const editor = CKEDITOR.instances['activityContent'];
    if (editor) {
      const message = CKEDITOR.instances['activityContent'].getData();
      localStorage.setItem('exo-activity-composer-message', message);
      localStorage.setItem('exo-activity-composer-attachments', JSON.stringify(attachments));
    }
    window.open(url, '_blank');
  }
};

export function initExtensions() {
  csTicketFeedbackPlugin.enabled = eXo.env.portal.spaceTemplate && eXo.env.portal.spaceTemplate === 'CSSpace';
  extensionRegistry.registerExtension('ActivityComposer', 'activity-composer-action', csTicketFeedbackPlugin);

  document.dispatchEvent(new CustomEvent('activity-composer-extension-updated'));
}
