/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.entity;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.exoplatform.commons.api.persistence.ExoEntity;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Entity(name = "CSTypeEntity")
@ExoEntity
@Table(name = "CS_ADDON_TYPES")
@DiscriminatorColumn(name = "TYPE_NAME", discriminatorType = DiscriminatorType.STRING, length = 20)
@NamedQueries({
 @NamedQuery(name = "typeEntity.getTypeByName", query = "SELECT a FROM CSTypeEntity a where a.label = :name"),
 @NamedQuery(name = "typeEntity.getTypeObjects", query = "SELECT a FROM CSTypeEntity a where a.class = :className")})
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TypeEntity {
  @Id
  @Column(name = "TYPE_ID")
  @SequenceGenerator(name = "SEQ_CS_TYPE_ID")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_CS_TYPE_ID")
  private Long    id;

  @Column(name = "TYPE_LABEL", nullable = false)
  private String  label;

  @Column(name = "TYPE_OTHER", nullable = false)
  private Boolean other = false;
}
