/*
 * Copyright (C) 2003-2015 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.integration.notification;


import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;


public class CSPrivatePostPlugin extends BaseNotificationPlugin {

  private static final Log LOG = ExoLogger.getLogger(CSPrivatePostPlugin.class);

  public final static String ID = "CSPrivatePostPlugin";


  public final static ArgumentLiteral<TopicEntity> TICKET = new ArgumentLiteral<TopicEntity>(TopicEntity.class, "ticket");
  public final static ArgumentLiteral<String> POST = new ArgumentLiteral<String>(String.class, "post");
  public final static ArgumentLiteral<String> POSTER = new ArgumentLiteral<String>(String.class, "poster");




  IdentityManager identityManager;

  public CSPrivatePostPlugin(InitParams initParams, IdentityManager identityManager) {

    super(initParams);
    this.identityManager = identityManager;

  }



  @Override

  public String getId() {

    return ID;

  }



  @Override

  public boolean isValid(NotificationContext ctx) {

    return true;

  }




  @Override

  protected NotificationInfo makeNotification(NotificationContext ctx) {

    TopicEntity ticket = ctx.value(TICKET);
    Set<String> receivers = new HashSet<String>();
/*    try {
      List<User> users = CSUtils.getSupportMembers();
      for(User user : users){
          receivers.add(user.getUserName());
      }
    } catch (Exception e) {
      LOG.warn("Cannot get the list of support mrmbers");
    }*/
    if(ticket.getAssignee()!=null)
    {receivers.add(ticket.getAssignee());
    }else{
      receivers.add("support");
    }
    StringBuilder activityId = new StringBuilder("support");
    activityId.append("-").append(ticket.getId());
    String ticketUrl = CommonsUtils.getCurrentDomain()+ticket.getLink();
    String post = ctx.value(POST);
    String poster = ctx.value(POSTER);
    String ticketId = ticket.getTicketId();
    String ticketTitle = ticket.getTitle();


    return NotificationInfo.instance()

            .setFrom("support")
            .to(new LinkedList<String>(receivers))
            .with(NotificationUtils.CREATOR, poster)
            .with(NotificationUtils.USER_NAME, ticket.getAssignee())
            .with(NotificationUtils.TICKET_URL, ticketUrl)
            .with(NotificationUtils.ACTIVITY_ID, activityId.toString())
            .with(NotificationUtils.TICKET_ID, ticketId)
            .with(NotificationUtils.TICKET_TITLE, ticketTitle)
            .with(NotificationUtils.POST, post.replace("alert alert-warning",""))
            .with(NotificationUtils.TICKET_STATUS, ticket.getStatus())
            .key(getKey()).end();

  }
}