package org.exoplatform.cs.rest.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.cs.dto.BasicEntityDTO;
import org.exoplatform.task.domain.Priority;

import java.io.Serializable;
import java.util.Set;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CSpace implements Cloneable, Serializable {
    private String name;
    private String prettyName;
    private String description;
    private String groupId;
    private String url;
    private BasicEntityDTO taskDefaultAssignee;
    private String tagPrefix;
    private BasicEntityDTO managersGroupId;
    private BasicEntityDTO invitedMembersGroupId;
    private Set<BasicEntityDTO> members;
    private long tagIndex = 1;
    private Priority taskPriority = Priority.NORMAL;
    private String owner;
    private long limitTicketsNumber;
    private long supportTickets;
    private long actifTickets;
    private long productTickets;
    private long totalTickets;
    private String incidentFlow;
    private String informationFlow;
    private String language;
    private boolean hosted;
    private String sla;
    private String subscription;
    private String subscriptionStartDate;
    private String subscriptionEndDate;
    private boolean subscriptionActive;
    private boolean internal;
    private String customerExtensionVersion;
    private String installedPatchVersion;
    private String avatarUrl;

    public CSpace clone() {
        return new CSpace(name, prettyName, description, groupId, url, taskDefaultAssignee, tagPrefix,
                managersGroupId, invitedMembersGroupId, members, tagIndex, taskPriority, owner,
                limitTicketsNumber, supportTickets, actifTickets, productTickets, totalTickets, incidentFlow,
                informationFlow, language, hosted, sla, subscription, subscriptionStartDate, subscriptionEndDate,
                subscriptionActive, internal, customerExtensionVersion, installedPatchVersion, avatarUrl);

    }
}
