import CsCustomEditor from './components/CsCustomEditor.vue';

import * as csUtils from '../services/Utils.js';
import * as csService from '../services/CSService.js';
import * as ticketService from '../services/TicketService.js';


const components = {
  'cs-custom-editor': CsCustomEditor
};

for (const key in components) {
  Vue.component(key, components[key]);
}

if (!Vue.prototype.$csUtils) {
  window.Object.defineProperty(Vue.prototype, '$csUtils', {
    value: csUtils,
  });
}
if (!Vue.prototype.$csService) {
  window.Object.defineProperty(Vue.prototype, '$csService', {
    value: csService,
  });
}

if (!Vue.prototype.$ticketService) {
  window.Object.defineProperty(Vue.prototype, '$ticketService', {
    value: ticketService,
  });
}