/*
 * Decompiled with CFR 0.152.
 */
package org.services.notification.cms.templates.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.services.notification.cms.templates.utils.NotificationUtils;

public class PostUpdateStatePlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PostUpdateStatePlugin.class);
    public static final String ID = "PostUpdateStatePlugin";
    private OrganizationService orgService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
    private UserHandler userhandler = this.orgService.getUserHandler();
    private MembershipHandler membershipHandler = this.orgService.getMembershipHandler();
    public static final ArgumentLiteral<String> CONTENT_TITLE = new ArgumentLiteral(String.class, "CONTENT_TITLE");
    public static final ArgumentLiteral<String> CONTENT_UPDATER = new ArgumentLiteral(String.class, "CONTENT_UPDATER");
    public static final ArgumentLiteral<String> CONTENT_STATUS = new ArgumentLiteral(String.class, "CONTENT_STATUS");
    public static final ArgumentLiteral<String> CONTENT_URL = new ArgumentLiteral(String.class, "CONTENT_URL");
    public static final ArgumentLiteral<String> PUBLICATION_LIFECYCLE = new ArgumentLiteral(String.class, "PUBLICATION_LIFECYCLE");

    public PostUpdateStatePlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String contentTitle = (String)ctx.value(CONTENT_TITLE);
        String contentStatus = (String)ctx.value(CONTENT_STATUS);
        String contentUpdater = (String)ctx.value(CONTENT_UPDATER);
        String contentUrl = (String)ctx.value(CONTENT_URL);
        String lifecycle = (String)ctx.value(PUBLICATION_LIFECYCLE);
        ArrayList receiversIds = new ArrayList();
        try {
            List<User> receivers = this.getReceivers(contentStatus, lifecycle);
            receivers.forEach(u -> receiversIds.add(u.getUserName()));
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to have the list of receivers " + e.getMessage()));
        }
        HashSet receiversSet = new HashSet(receiversIds);
        if (contentStatus.equals("draft") || contentStatus.equals("pending")) {
            receiversSet.remove(contentUpdater);
        }
        ArrayList receiverIdsList = new ArrayList(receiversSet);
        return NotificationInfo.instance().setFrom(contentUpdater).with("CONTENT_TITLE", contentTitle).to(receiverIdsList).with("CONTENT_STATUS", contentStatus).with("CONTENT_UPDATER", contentUpdater).with("CONTENT_URL", contentUrl).key(this.getKey()).end();
    }

    private List<User> getReceivers(String contentStatus, String lifecycleName) throws Exception {
        List<User> receivers = new ArrayList<User>();
        List<LifecyclesConfig.State> stateList = NotificationUtils.getStates(lifecycleName);
        if (contentStatus.equals("draft")) {
            for (LifecyclesConfig.State state : stateList) {
                if (!state.getState().equals(contentStatus) && !state.getState().equals("pending")) continue;
                receivers = this.getAllUsersByState(state, receivers);
            }
        }
        if (contentStatus.equals("pending")) {
            for (LifecyclesConfig.State state : stateList) {
                if (!state.getState().equals("approved")) continue;
                receivers = this.getAllUsersByState(state, receivers);
            }
        }
        if (contentStatus.equals("approved")) {
            for (LifecyclesConfig.State state : stateList) {
                if (!state.getState().equals(contentStatus) && !state.getState().equals("pending") && !state.getState().equals("staged") && !state.getState().equals("published")) continue;
                receivers = this.getAllUsersByState(state, receivers);
            }
        }
        if (contentStatus.equals("staged")) {
            for (LifecyclesConfig.State state : stateList) {
                if (!state.getState().equals("published")) continue;
                receivers = this.getAllUsersByState(state, receivers);
            }
        }
        if (contentStatus.equals("published")) {
            for (LifecyclesConfig.State state : stateList) {
                if (!state.getState().equals(contentStatus) && !state.getState().equals("pending") && !state.getState().equals("approved") && !state.getState().equals("staged")) continue;
                receivers = this.getAllUsersByState(state, receivers);
            }
        }
        return receivers;
    }

    private List<User> getAllUsersByState(LifecyclesConfig.State state, List<User> receivers) throws Exception {
        List memberships;
        String membership = state.getMembership();
        if (membership != null) {
            receivers.addAll(this.getAllUserByMemberShip(membership, receivers));
        }
        if ((memberships = state.getMemberships()) != null) {
            for (String m : memberships) {
                receivers.addAll(this.getAllUserByMemberShip(m, receivers));
            }
        }
        return receivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<User> getAllUserByMemberShip(String membership, List<User> receivers) throws Exception {
        String[] membershipTab = membership.split(":");
        String membershipType = membershipTab[0];
        String group = membershipTab[1];
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ListAccess userList = this.userhandler.findUsersByGroupId(group);
            for (User user : (User[])userList.load(0, userList.getSize())) {
                Collection membershipsCollection = this.membershipHandler.findMembershipsByUserAndGroup(user.getUserName(), group);
                for (Membership ms : membershipsCollection) {
                    if (!membershipType.equals(ms.getMembershipType()) && !ms.getMembershipType().equals("*")) continue;
                    receivers.add(user);
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        return receivers;
    }
}

