package org.services.listener;

import javax.jcr.Node;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodetypeConstant;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.AuthoringPublicationConstant;
import org.services.notification.cms.templates.plugin.PostUpdateStatePlugin;
import org.services.notification.cms.templates.utils.NotificationConstants;

public class PostUpdateStateListener extends Listener<Object, Node> {
  private static final Log LOG = ExoLogger.getLogger(PostUpdateStateListener.class.getName());

  @Override
  public void onEvent(Event<Object, Node> event) throws Exception {
    LOG.info("the status was updated");
    Node content = event.getData();
    String contentStatus = content.getProperty(AuthoringPublicationConstant.CURRENT_STATE).getValue().getString();
    String contentTitle = content.getProperty(NodetypeConstant.EXO_TITLE).getValue().getString();
    String contentUpdater = content.getProperty(NodetypeConstant.EXO_LAST_MODIFIER).getValue().getString();
    String lifecycle = content.getProperty(NotificationConstants.PUBLICATION_LIFECYCLE).getValue().getString();

    String domainName = PropertyManager.getProperty("gatein.email.domain.url");
    DocumentService documentService = (DocumentService) CommonsUtils.getService(DocumentService.class);
    
    if (content.getPath() != null) {
      String contentUrl = domainName;
      String contentPath = content.getPath();
      if (ConversationState.getCurrent() != null) {
        if (ConversationState.getCurrent().getIdentity() != null) {
          String userId = ConversationState.getCurrent().getIdentity().getUserId();
          if (userId != null) {
            DriveData driveData = documentService.getDriveOfNode(contentPath);
            if (driveData != null) {
              if (documentService.getLinkInDocumentsApp(content.getPath()) != null) {
                contentUrl = contentUrl + documentService.getLinkInDocumentsApp(contentPath);
                // Send Notification
                NotificationContext ctx = NotificationContextImpl.cloneInstance()
                                                                 .append(PostUpdateStatePlugin.CONTENT_TITLE, contentTitle)
                                                                 .append(PostUpdateStatePlugin.CONTENT_STATUS, contentStatus)
                                                                 .append(PostUpdateStatePlugin.CONTENT_UPDATER, contentUpdater)
                                                                 .append(PostUpdateStatePlugin.PUBLICATION_LIFECYCLE, lifecycle)
                                                                 .append(PostUpdateStatePlugin.CONTENT_URL, contentUrl);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(PostUpdateStatePlugin.ID))).execute(ctx);
                LOG.info("A notification was sent");

              }
            }
          }
        }
      }

    }

  }

}
