/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.addons.populator.bean.ActivityBean;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

@Named(value="activityService")
@ApplicationScoped
public class ActivityService {
    Logger log = Logger.getLogger("ActivityService");
    ActivityManager activityManager_;
    IdentityManager identityManager_;
    Random random = new Random();

    @Inject
    public ActivityService(ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager_ = activityManager;
        this.identityManager_ = identityManager;
    }

    public void pushActivities(List<ActivityBean> activities) throws Exception {
        for (ActivityBean activity : activities) {
            this.pushActivity(activity);
        }
        this.likeRandomActivities(Utils.MARY);
        this.likeRandomActivities(Utils.JAMES);
    }

    private void pushActivity(ActivityBean activityBean) throws Exception {
        String from = activityBean.getFrom();
        Identity identity = this.identityManager_.getOrCreateIdentity("organization", from, false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setBody(activityBean.getBody());
        activity.setTitle(activityBean.getBody());
        activity.setUserId(identity.getId());
        activity = this.activityManager_.saveActivity(identity, (ExoSocialActivity)activity);
        for (ActivityBean commentBean : activityBean.getComments()) {
            Thread.sleep(1000L);
            Identity identityComment = this.identityManager_.getOrCreateIdentity("organization", commentBean.getFrom(), false);
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle(commentBean.getBody());
            comment.setUserId(identityComment.getId());
            this.activityManager_.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
    }

    private void likeRandomActivities(String username) {
        boolean like;
        ExoSocialActivity activityMary;
        int iam;
        Identity identity = this.identityManager_.getOrCreateIdentity("organization", username, false);
        RealtimeListAccess rtla = this.activityManager_.getActivitiesWithListAccess(identity);
        ExoSocialActivity[] la = (ExoSocialActivity[])rtla.load(0, rtla.getSize());
        for (iam = 0; iam < la.length; ++iam) {
            activityMary = la[iam];
            like = this.random.nextBoolean();
            if (!like) continue;
            this.activityManager_.saveLike(activityMary, identity);
        }
        rtla = this.activityManager_.getActivitiesOfUserSpacesWithListAccess(identity);
        la = (ExoSocialActivity[])rtla.load(0, rtla.getSize());
        for (iam = 0; iam < la.length; ++iam) {
            activityMary = la[iam];
            like = this.random.nextBoolean();
            if (!like) continue;
            this.activityManager_.saveLike(activityMary, identity);
        }
    }
}

