/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.populator.bean.RelationBean;
import org.exoplatform.addons.populator.bean.UserBean;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.webui.exception.MessageException;

@Named(value="userService")
@SessionScoped
public class UserService {
    OrganizationService organizationService_;
    UserHandler userHandler_;
    IdentityManager identityManager_;
    RelationshipManager relationshipManager_;
    Logger log = Logger.getLogger("UserService");
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private static final int WIDTH = 200;

    @Inject
    public UserService(OrganizationService organizationService, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.organizationService_ = organizationService;
        this.userHandler_ = this.organizationService_.getUserHandler();
        this.identityManager_ = identityManager;
        this.relationshipManager_ = relationshipManager;
    }

    public void createUsers(List<UserBean> users) {
        for (UserBean user : users) {
            this.createUser(user.getUsername(), user.getPosition(), user.getFirstname(), user.getLastname(), user.getEmail(), user.getPassword(), user.getIsAdmin().booleanValue());
        }
    }

    public boolean attachAvatars(List<UserBean> users) {
        boolean ok = true;
        for (UserBean user : users) {
            this.saveUserAvatar(user.getUsername(), user.getAvatar());
        }
        return ok;
    }

    public void createRelations(List<RelationBean> relations) {
        for (RelationBean relation : relations) {
            Identity idInviting = this.identityManager_.getOrCreateIdentity("organization", relation.getInviting(), false);
            Identity idInvited = this.identityManager_.getOrCreateIdentity("organization", relation.getInvited(), false);
            this.relationshipManager_.inviteToConnect(idInviting, idInvited);
            if (!relation.getConfirm().booleanValue()) continue;
            this.relationshipManager_.confirm(idInvited, idInviting);
        }
    }

    private boolean createUser(String username, String position, String firstname, String lastname, String email, String password, boolean isAdmin) {
        Identity identity;
        Boolean ok = true;
        User user = null;
        try {
            user = this.userHandler_.findUserByName(username);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
        }
        if (user != null) {
            return true;
        }
        user = this.userHandler_.createUserInstance(username);
        user.setDisplayName(firstname + " " + lastname);
        user.setEmail(email);
        user.setFirstName(firstname);
        user.setLastName(lastname);
        user.setPassword(password);
        try {
            this.userHandler_.createUser(user, true);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
            ok = false;
        }
        if (isAdmin) {
            try {
                Group group = this.organizationService_.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                MembershipType membershipType = this.organizationService_.getMembershipTypeHandler().findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService_.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                this.log.warning("Can not assign *:/platform/administrators membership to the created user");
                ok = false;
            }
        }
        if (!"".equals(position) && (identity = this.identityManager_.getOrCreateIdentity("organization", username, true)) != null) {
            Profile profile = identity.getProfile();
            profile.setProperty("position", (Object)position);
            profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
            try {
                this.identityManager_.updateProfile(profile);
            }
            catch (MessageException e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    private void saveUserAvatar(String username, String fileName) {
        try {
            AvatarAttachment avatarAttachment = Utils.getAvatarAttachment((String)fileName);
            Profile p = this.identityManager_.getOrCreateIdentity("organization", username, true).getProfile();
            p.setProperty("avatar", (Object)avatarAttachment);
            p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
            Map props = p.getProperties();
            for (String key : props.keySet()) {
                if (!key.startsWith("avatar_")) continue;
                p.removeProperty(key);
            }
            this.identityManager_.updateProfile(p);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
        }
    }
}

