/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.exoplatform.addons.sdpDemo.populator.services.ActivityService;
import org.exoplatform.addons.sdpDemo.populator.services.CalendarService;
import org.exoplatform.addons.sdpDemo.populator.services.DocumentService;
import org.exoplatform.addons.sdpDemo.populator.services.ForumService;
import org.exoplatform.addons.sdpDemo.populator.services.SpaceService;
import org.exoplatform.addons.sdpDemo.populator.services.UserService;
import org.exoplatform.addons.sdpDemo.populator.services.WikiService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class PopulatorService {
    private final Log LOG = ExoLogger.getLogger(PopulatorService.class);
    public String SCENARIO_FOLDER = "/scenarios";
    public String SCENARIO_NAME_ATTRIBUTE = "scenarioName";
    public String SCENARIO_DESCRIPTION_ATTRIBUTE = "scenarioName";
    @Inject
    UserService userService_;
    @Inject
    SpaceService spaceService_;
    @Inject
    CalendarService calendarService_;
    @Inject
    WikiService wikiService_;
    @Inject
    ForumService forumService_;
    @Inject
    DocumentService documentService_;
    @Inject
    ActivityService activityService_;
    private Map<String, JSONObject> scenarios;
    Map<String, Integer> completion = new HashMap();
    public final String USERS = "Users";
    public final String SPACES = "Spaces";
    public final String CALENDAR = "Calendar";
    public final String WIKI = "Wiki";
    public final String DOCUMENTS = "Documents";
    public final String FORUM = "Forum";
    public final String ACTIVITIES = "Activities";

    public PopulatorService() {
        this.init();
    }

    public void init() {
        this.scenarios = new HashMap();
        try {
            File folder = new File(PopulatorService.class.getClassLoader().getResource(this.SCENARIO_FOLDER).toURI());
            for (String fileName : folder.list()) {
                InputStream stream = PopulatorService.class.getClassLoader().getResourceAsStream(this.SCENARIO_FOLDER + "/" + fileName);
                String fileContent = this.getData(stream);
                try {
                    JSONObject json = new JSONObject(fileContent);
                    String name = json.getString(this.SCENARIO_NAME_ATTRIBUTE);
                    this.scenarios.put(name, json);
                }
                catch (JSONException e) {
                    this.LOG.error((Object)("Syntax error in scenario " + fileName), (Throwable)e);
                }
            }
        }
        catch (URISyntaxException e) {
            this.LOG.error((Object)"Unable to read scenario file", (Throwable)e);
        }
        this.completion.put("Users", 0);
        this.completion.put("Spaces", 0);
        this.completion.put("Calendar", 0);
        this.completion.put("Wiki", 0);
        this.completion.put("Documents", 0);
        this.completion.put("Forum", 0);
        this.completion.put("Activities", 0);
    }

    public String populate(String scenarioName) {
        this.completion.put("Users", 0);
        this.completion.put("Spaces", 0);
        this.completion.put("Calendar", 0);
        this.completion.put("Wiki", 0);
        this.completion.put("Documents", 0);
        this.completion.put("Forum", 0);
        this.completion.put("Activities", 0);
        String downloadUrl = "";
        try {
            JSONObject scenarioData = ((JSONObject)this.scenarios.get(scenarioName)).getJSONObject("data");
            if (scenarioData.has("users")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("users").length() + " users."));
                this.userService_.createUsers(scenarioData.getJSONArray("users"), this);
            }
            if (scenarioData.has("relations")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("relations").length() + " relations."));
                this.userService_.createRelations(scenarioData.getJSONArray("relations"));
            }
            if (scenarioData.has("spaces")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("spaces").length() + " spaces."));
                this.spaceService_.createSpaces(scenarioData.getJSONArray("spaces"), this);
            }
            if (scenarioData.has("calendars")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("calendars").length() + " calendars."));
                this.calendarService_.setCalendarColors(scenarioData.getJSONArray("calendars"), this);
                this.calendarService_.createEvents(scenarioData.getJSONArray("calendars"), this);
            }
            if (scenarioData.has("wikis")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("wikis").length() + " wikis."));
                this.wikiService_.createUserWiki(scenarioData.getJSONArray("wikis"), this);
            }
            if (scenarioData.has("activities")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("activities").length() + " activities."));
                this.activityService_.pushActivities(scenarioData.getJSONArray("activities"), this);
            }
            if (scenarioData.has("documents")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("documents").length() + " documents."));
                this.documentService_.uploadDocuments(scenarioData.getJSONArray("documents"), this);
            }
            if (scenarioData.has("forums")) {
                this.forumService_.createForumContents(scenarioData.getJSONArray("forums"), this);
            }
            if (((JSONObject)this.scenarios.get(scenarioName)).has("scriptData")) {
                downloadUrl = this.documentService_.storeScript(((JSONObject)this.scenarios.get(scenarioName)).getString("scriptData"));
            }
        }
        catch (JSONException e) {
            this.LOG.error((Object)("Syntax error when reading scenario " + scenarioName), (Throwable)e);
        }
        return downloadUrl;
    }

    public String getData(InputStream inputStream) {
        String out = "";
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            out = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public Map<String, JSONObject> getScenarios() {
        return this.scenarios;
    }

    public void setCompletion(String category, int value) {
        this.completion.put(category, value);
    }

    public String getCompletionAsJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String key : this.completion.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("{\"name\": \"" + key + "\",");
            sb.append("\"percentage\": \"" + this.completion.get(key) + "%\"}");
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }
}

