/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.addons.sdpDemo.populator.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="spaceService")
@SessionScoped
public class SpaceService {
    org.exoplatform.social.core.space.spi.SpaceService spaceService_;
    IdentityManager identityManager_;
    private final Log LOG = ExoLogger.getLogger(SpaceService.class);

    @Inject
    public SpaceService(org.exoplatform.social.core.space.spi.SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService_ = spaceService;
        this.identityManager_ = identityManager;
    }

    public void createSpaces(JSONArray spaces, PopulatorService populatorService_) {
        for (int i = 0; i < spaces.length(); ++i) {
            try {
                JSONObject space = spaces.getJSONObject(i);
                this.createSpace(space.getString("displayName"), space.getString("creator"));
                if (space.has("members")) {
                    JSONArray members = space.getJSONArray("members");
                    for (int j = 0; j < members.length(); ++j) {
                        Space spacet = this.spaceService_.getSpaceByDisplayName(space.getString("displayName"));
                        if (spacet == null) continue;
                        this.spaceService_.addMember(spacet, members.getString(j));
                    }
                }
                this.createSpaceAvatar(space.getString("displayName"), space.getString("creator"), space.getString("avatar"));
                populatorService_.getClass();
                populatorService_.setCompletion("Spaces", (i + 1) * 100 / spaces.length());
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on space n\u00b0" + i), (Throwable)e);
            }
        }
    }

    private void createSpaceAvatar(String name, String editor, String avatarFile) {
        Space space = this.spaceService_.getSpaceByDisplayName(name);
        if (space != null) {
            try {
                AvatarAttachment avatarAttachment = Utils.getAvatarAttachment((String)avatarFile);
                space.setAvatarAttachment(avatarAttachment);
                this.spaceService_.updateSpace(space);
                space.setEditor(editor);
                this.spaceService_.updateSpaceAvatar(space);
            }
            catch (Exception e) {
                this.LOG.error("Unable to set avatar for space " + space.getDisplayName(), new Object[]{e.getMessage()});
            }
        }
    }

    private void createSpace(String name, String creator) {
        Space target = this.spaceService_.getSpaceByDisplayName(name);
        if (target != null) {
            return;
        }
        Space space = new Space();
        space.setDisplayName(name);
        space.setPrettyName(name);
        space.setDescription("");
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setVisibility("private");
        space.setPriority("2");
        Identity identity = this.identityManager_.getOrCreateIdentity("space", space.getPrettyName(), true);
        if (identity != null) {
            space.setPrettyName(SpaceUtils.buildPrettyName((Space)space));
        }
        space.setType("classic");
        this.spaceService_.createSpace(space, creator);
    }
}

