/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.exoplatform.injection.core.module.ActivityModule;
import org.exoplatform.injection.core.module.CalendarModule;
import org.exoplatform.injection.core.module.DocumentModule;
import org.exoplatform.injection.core.module.ForumModule;
import org.exoplatform.injection.core.module.SpaceModule;
import org.exoplatform.injection.core.module.UserModule;
import org.exoplatform.injection.core.module.WikiModule;
import org.exoplatform.injection.helper.InjectorMonitor;
import org.exoplatform.injection.services.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class PopulatorService {
    private final Log LOG = ExoLogger.getLogger(PopulatorService.class);
    public String SCENARIO_FOLDER = "/scenarios";
    public String SCENARIO_NAME_ATTRIBUTE = "scenarioName";
    public String SCENARIO_DESCRIPTION_ATTRIBUTE = "scenarioName";
    ActivityModule activityModule;
    CalendarModule calendarModule;
    DocumentModule documentModule;
    ForumModule forumModule;
    SpaceModule spaceModule;
    UserModule userModule;
    WikiModule wikiModule;
    DataInjector dataInjector;
    private Map<String, JSONObject> scenarios;
    Map<String, Integer> completion = new HashMap();
    public final String USERS = "Users";
    public final String SPACES = "Spaces";
    public final String CALENDAR = "Calendar";
    public final String WIKI = "Wiki";
    public final String DOCUMENTS = "Documents";
    public final String FORUM = "Forum";
    public final String ACTIVITIES = "Activities";

    @Inject
    public PopulatorService(DataInjector dataInjector, ActivityModule activityModule, CalendarModule calendarModule, DocumentModule documentModule, ForumModule forumModule, SpaceModule spaceModule, UserModule userModule, WikiModule wikiModule) {
        this.activityModule = activityModule;
        this.calendarModule = calendarModule;
        this.documentModule = documentModule;
        this.forumModule = forumModule;
        this.spaceModule = spaceModule;
        this.userModule = userModule;
        this.wikiModule = wikiModule;
        this.dataInjector = dataInjector;
        this.init();
    }

    public void init() {
        this.scenarios = this.dataInjector.setup("injector-dataset");
    }

    public String populate(String scenarioName) {
        this.completion.put("Users", 0);
        this.completion.put("Spaces", 0);
        this.completion.put("Calendar", 0);
        this.completion.put("Wiki", 0);
        this.completion.put("Documents", 0);
        this.completion.put("Forum", 0);
        this.completion.put("Activities", 0);
        String downloadUrl = "";
        InjectorMonitor injectorMonitor = new InjectorMonitor("Data Injection Process");
        try {
            JSONObject scenarioData = ((JSONObject)this.scenarios.get(scenarioName)).getJSONObject("data");
            if (scenarioData.has("users")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("users").length() + " users."));
                this.getClass();
                this.setCompletion("Users", 20);
                injectorMonitor.start("Processing users data");
                this.userModule.createUsers(scenarioData.getJSONArray("users"), "injector-dataset");
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Users", 100);
            }
            if (scenarioData.has("relations")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("relations").length() + " relations."));
                injectorMonitor.start("Processing users data");
                this.userModule.createRelations(scenarioData.getJSONArray("relations"));
                injectorMonitor.stop();
            }
            if (scenarioData.has("spaces")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("spaces").length() + " spaces."));
                this.getClass();
                this.setCompletion("Spaces", 40);
                injectorMonitor.start("Processing users data");
                this.spaceModule.createSpaces(scenarioData.getJSONArray("spaces"), "injector-dataset");
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Spaces", 100);
            }
            if (scenarioData.has("calendars")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("calendars").length() + " calendars."));
                injectorMonitor.start("Processing users data");
                this.getClass();
                this.setCompletion("Calendar", 10);
                this.calendarModule.setCalendarColors(scenarioData.getJSONArray("calendars"));
                this.getClass();
                this.setCompletion("Calendar", 70);
                this.calendarModule.createEvents(scenarioData.getJSONArray("calendars"));
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Calendar", 100);
            }
            if (scenarioData.has("wikis")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("wikis").length() + " wikis."));
                this.getClass();
                this.setCompletion("Wiki", 60);
                injectorMonitor.start("Processing users data");
                this.wikiModule.createUserWiki(scenarioData.getJSONArray("wikis"), "injector-dataset");
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Wiki", 100);
            }
            if (scenarioData.has("activities")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("activities").length() + " activities."));
                this.getClass();
                this.setCompletion("Activities", 10);
                injectorMonitor.start("Processing users data");
                this.activityModule.pushActivities(scenarioData.getJSONArray("activities"));
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Activities", 100);
            }
            if (scenarioData.has("documents")) {
                this.LOG.info((Object)("Create " + scenarioData.getJSONArray("documents").length() + " documents."));
                this.getClass();
                this.setCompletion("Documents", 10);
                injectorMonitor.start("Processing users data");
                this.documentModule.uploadDocuments(scenarioData.getJSONArray("documents"), "injector-dataset");
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Documents", 100);
            }
            if (scenarioData.has("forums")) {
                injectorMonitor.start("Processing users data");
                this.forumModule.createForumContents(scenarioData.getJSONArray("forums"));
                injectorMonitor.stop();
                this.getClass();
                this.setCompletion("Forum", 100);
            }
            this.getClass();
            this.setCompletion("Forum", 100);
            if (((JSONObject)this.scenarios.get(scenarioName)).has("scriptData")) {
                downloadUrl = this.documentModule.storeScript(((JSONObject)this.scenarios.get(scenarioName)).getString("scriptData"), "injector-dataset");
            }
            this.LOG.info((Object)"Data Injection has been done successfully.............");
            this.LOG.info((Object)injectorMonitor.prettyPrint());
        }
        catch (JSONException e) {
            this.LOG.error((Object)("Syntax error when reading scenario " + scenarioName), (Throwable)e);
        }
        return downloadUrl;
    }

    public String getData(InputStream inputStream) {
        String out = "";
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            out = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public Map<String, JSONObject> getScenarios() {
        return this.scenarios;
    }

    public void setCompletion(String category, int value) {
        this.completion.put(category, value);
    }

    public String getCompletionAsJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String key : this.completion.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("{\"name\": \"" + key + "\",");
            sb.append("\"percentage\": \"" + this.completion.get(key) + "%\"}");
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }
}

