/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.channel.template;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="DlpAdminDetectedItemPlugin", template="war:/notification/templates/DlpAdminDetectedItemPlugin.gtmpl"), @TemplateConfig(pluginId="DlpUserDetectedItemPlugin", template="war:/notification/templates/DlpUserDetectedItemPlugin.gtmpl"), @TemplateConfig(pluginId="DlpUserRestoredItemPlugin", template="war:/notification/templates/DlpUserRestoredItemPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    private static final String ITEM_TITLE_NOTIFICATION_PARAM = "itemTitle";
    private static final String ITEM_TITLE = "ITEM_TITLE";
    private AbstractTemplateBuilder dlpAdminDetectedItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)MailTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(MailTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            templateContext.put((Object)"DLP_PAGE_URL", (Object)DlpUtils.getQuarantineRedirectURL());
            SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder dlpUserDetectedItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
            templateContext.put((Object)MailTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(MailTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            templateContext.put((Object)"ITEM_AUTHOR", (Object)notification.getValueOwnerParameter("itemAuthor"));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder dlpUserRestoredItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            MessageInfo messageInfo = new MessageInfo();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
            templateContext.put((Object)MailTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(MailTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            templateContext.put((Object)"ITEM_URL", (Object)DlpUtils.getDlpRestoredUrl(notification.getValueOwnerParameter("itemReference")));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"DlpAdminDetectedItemPlugin"), this.dlpAdminDetectedItem);
        this.templateBuilders.put(PluginKey.key((String)"DlpUserDetectedItemPlugin"), this.dlpUserDetectedItem);
        this.templateBuilders.put(PluginKey.key((String)"DlpUserRestoredItemPlugin"), this.dlpUserRestoredItem);
    }
}

