/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity
@ExoEntity
@Table(name="DLP_QUEUE")
@NamedQueries(value={@NamedQuery(name="DlpOperation.findByEntityIdAndType", query="SELECT q FROM DlpOperation q WHERE q.entityId = :entityId and q.entityType = :entityType"), @NamedQuery(name="DlpOperation.findAllFirstWithOffset", query="SELECT q FROM DlpOperation q ORDER BY q.id"), @NamedQuery(name="DlpOperation.deleteByEntityId", query="DELETE FROM DlpOperation q WHERE q.entityId = :entityId")})
public class DlpOperation
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_DLP_QUEUE_ID", sequenceName="SEQ_DLP_QUEUE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_DLP_QUEUE_ID")
    @Column(name="OPERATION_ID")
    private Long id;
    @Column(name="ENTITY_TYPE")
    private String entityType;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="OPERATION_TIMESTAMP", insertable=false, updatable=false)
    private Date timestamp;

    public DlpOperation() {
    }

    public DlpOperation(String entityId, String entityType) {
        this.entityId = entityId;
        this.entityType = entityType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DlpOperation that = (DlpOperation)o;
        return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DlpOperation{id=" + this.id + ", entityType='" + this.entityType + "', entityId='" + this.entityId + "', timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

