/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.queue.QueueDlpService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedAction;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedActionException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileDLPAction
implements AdvancedAction {
    private static final Log LOGGER = ExoLogger.getExoLogger(FileDLPAction.class);
    private TrashService trashService = (TrashService)CommonsUtils.getService(TrashService.class);
    private QueueDlpService queueDlpService = (QueueDlpService)CommonsUtils.getService(QueueDlpService.class);
    private ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);
    private DlpOperationProcessor dlpOperationProcessor = (DlpOperationProcessor)CommonsUtils.getService(DlpOperationProcessor.class);
    private static final String EXO_EDITORS_RUNTIME_ID = "exo:editorsId";
    private static final List<String> excludedPropertyNames = Collections.unmodifiableList(Arrays.asList("exo:editorsId", "exo:currentProvider", "exo:restorePath"));

    public boolean execute(Context context) throws Exception {
        if (!this.featureService.isActiveFeature("dlp") || StringUtils.isBlank((CharSequence)this.dlpOperationProcessor.getKeywords())) {
            return false;
        }
        int eventType = (Integer)context.get((Object)InvocationContext.EVENT);
        switch (eventType) {
            case 1: {
                NodeImpl node = (NodeImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (node == null || this.trashService.isInTrash((Node)node)) break;
                if (node.isNodeType("nt:resource")) {
                    node = node.getParent();
                }
                String entityId = node.getInternalIdentifier();
                this.queueDlpService.addToQueue("file", entityId);
                break;
            }
            case 4: 
            case 16: {
                NodeImpl node;
                PropertyImpl property = (PropertyImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (property == null || excludedPropertyNames.contains(property.getName()) || (node = property.getParent()) == null || this.trashService.isInTrash((Node)node)) break;
                if (node.isNodeType("nt:resource")) {
                    node = node.getParent();
                }
                if (!node.isNodeType("nt:file")) break;
                String entityId = node.getInternalIdentifier();
                this.queueDlpService.addToQueue("file", entityId);
            }
        }
        return true;
    }

    public void onError(Exception e, Context context) throws AdvancedActionException {
        LOGGER.error((Object)"Error while validating file", (Throwable)e);
    }
}

