/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.portal.rest.CollectionEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/dlp/items")
@Tag(name="/dlp/items", description="Manages Dlp positive items")
public class DlpItemRestServices
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(DlpItemRestServices.class);
    private DlpPositiveItemService dlpPositiveItemService;
    private DlpOperationProcessor dlpOperationProcessor;

    public DlpItemRestServices(DlpPositiveItemService dlpPositiveItemService, DlpOperationProcessor dlpOperationProcessor) {
        this.dlpPositiveItemService = dlpPositiveItemService;
        this.dlpOperationProcessor = dlpOperationProcessor;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of dlp positive items", method="GET", description="Return list of dlp positive items in json format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="50", description="Internal server error")})
    public Response getDlpPositiveItems(@Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) {
        if (!DlpUtils.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            List dlpPositiveItems = this.dlpPositiveItemService.getDlpPositivesItems(offset, limit);
            Long size = this.dlpPositiveItemService.getDlpPositiveItemsCount();
            CollectionEntity collectionDlpPositiveItem = new CollectionEntity(dlpPositiveItems, offset, limit, size.intValue());
            return Response.ok((Object)collectionDlpPositiveItem).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting dlp positive items", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/item/{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete a document by id", method="DELETE", description="This delete the document if the authenticated user is a super manager")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteDlpDocumentById(@Parameter(description="Document id", required=true) @PathParam(value="id") Long id) {
        if (!DlpUtils.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.dlpPositiveItemService.deleteDlpPositiveItem(id);
        return Response.ok().build();
    }

    @GET
    @Path(value="/keywords")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of dlp keywords", method="GET", description="Return list of dlp keywords in json format")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDlpKeywords() {
        if (!DlpUtils.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String keywords = this.dlpOperationProcessor.getKeywords();
            return Response.ok((Object)keywords).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting dlp keywords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/keywords")
    @RolesAllowed(value={"users"})
    @Operation(summary="set dlp keywords", method="POST", description="set the dlp keywords")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response setDlpKeywords(@Parameter(description="keywords", required=true) String keywords) {
        if (!DlpUtils.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.dlpOperationProcessor.setKeywords(keywords);
            return Response.ok().entity((Object)("{\"result\":\"" + keywords + "\"}")).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while setting dlp keywords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="item/restore/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Restore the dlp positive items", method="PUT", description="Return the restored positive item")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response restoreDlpPositiveItems(@Parameter(description="Document id", required=true) @PathParam(value="id") Long id) {
        if (!DlpUtils.isDlpAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.dlpPositiveItemService.restoreDlpPositiveItem(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while restoring dlp positive items", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

