/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.processor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.dlp.connector.DlpServiceConnector;
import org.exoplatform.dlp.dao.DlpOperationDAO;
import org.exoplatform.dlp.domain.DlpOperation;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DlpOperationProcessorImpl
extends DlpOperationProcessor
implements Startable {
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpOperationProcessorImpl.class);
    private static final Integer BATCH_NUMBER_DEFAULT = 1000;
    private static final String DLP_KEYWORDS = "exo.dlp.keywords";
    private static final Context DLP_CONTEXT = Context.GLOBAL.id("DlpKeywords");
    private static final Scope DLP_SCOPE = Scope.APPLICATION.id("DlpKeywords");
    private static final String EXO_DLP_KEYWORDS = "exo:dlpKeywords";
    private final DlpOperationDAO dlpOperationDAO;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private ExecutorService executors = Executors.newCachedThreadPool();
    private boolean interrupted = false;
    private boolean initialized = false;

    public DlpOperationProcessorImpl(DlpOperationDAO dlpOperationDAO) {
        this.dlpOperationDAO = dlpOperationDAO;
    }

    public void start() {
        this.initialized = true;
    }

    public void stop() {
        this.executors.shutdownNow();
    }

    @Override
    public String getKeywords() {
        SettingService settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        SettingValue settingValue = settingService.get(DLP_CONTEXT, DLP_SCOPE, EXO_DLP_KEYWORDS);
        return settingValue != null ? settingValue.getValue().toString() : System.getProperty(DLP_KEYWORDS);
    }

    @Override
    public boolean hasKeywords() {
        return !StringUtils.isEmpty((CharSequence)this.getKeywords());
    }

    @Override
    public void setKeywords(String keywords) {
        SettingService settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        settingService.set(DLP_CONTEXT, DLP_SCOPE, EXO_DLP_KEYWORDS, SettingValue.create((String)keywords));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void process() {
        if (!this.initialized) {
            LOGGER.debug((Object)"Skip Dlp queue processing until service is properly initialized");
            return;
        }
        this.interrupted = false;
        try {
            int totalProcessed = 0;
            int offset = 0;
            long total = this.dlpOperationDAO.count();
            while ((long)offset < total) {
                LOGGER.debug("Process Bulk DLP operation (offset : {}, total {})", new Object[]{offset, total});
                int stayingQueue = this.processBulk(offset);
                int processedOperations = this.batchNumber - stayingQueue;
                if (total < (long)this.batchNumber.intValue()) {
                    processedOperations = (int)(total - (long)stayingQueue);
                }
                total = this.dlpOperationDAO.count();
                offset += stayingQueue;
                totalProcessed += processedOperations;
                LOGGER.debug("DLP Operation processed : {} elements removed from queue, {} staying in queue, {} total elements in queue after operation", new Object[]{processedOperations, stayingQueue, total});
            }
            if (totalProcessed == 0 && offset == 0) {
                LOGGER.debug("Dlp Operation Processor proceed {} queue elements, {} elements staying in queue", new Object[]{totalProcessed, offset});
            } else {
                LOGGER.info("Dlp Operation Processor proceed {} queue elements, {} elements staying in queue", new Object[]{totalProcessed, offset});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error when processing bulk", (Throwable)e);
        }
        finally {
            if (this.interrupted) {
                LOGGER.debug((Object)"Dlp queue processing interruption done");
            }
        }
    }

    @Override
    public void interrupt() {
        LOGGER.debug((Object)"Dlp queue processing has been interrupted. Please wait until the service exists cleanly...");
        this.interrupted = true;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    private boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            LOGGER.debug((Object)"Thread running dlp queue processing has been interrupted. Please wait until the service exists cleanly...");
            this.interrupted = true;
        }
        return this.interrupted;
    }

    private int processBulk(int offset) {
        HashMap<String, List<DlpOperation>> dlpQueueSorted = new HashMap<String, List<DlpOperation>>();
        List dlpOperations = this.dlpOperationDAO.findAllFirstWithOffset(offset, this.batchNumber.intValue());
        LOGGER.debug("{} DLP operations found", new Object[]{dlpOperations.size()});
        for (DlpOperation dlpOperation : dlpOperations) {
            this.putDlpOperationInMemoryQueue(dlpOperation, dlpQueueSorted);
        }
        int nbElementsStayingInQueue = dlpOperations.size();
        for (Map.Entry dlpQueuSortedEntry : dlpQueueSorted.entrySet()) {
            DlpServiceConnector connector = this.getConnectors().get(dlpQueuSortedEntry.getKey());
            List dlpOperationsList = (List)dlpQueuSortedEntry.getValue();
            if (dlpOperationsList == null || dlpOperationsList.isEmpty()) continue;
            LOGGER.debug("Will proceed to DLP operation list for type {}, size {}", new Object[]{dlpQueuSortedEntry.getKey(), dlpOperationsList.size()});
            Iterator dlpOperationsIterator = dlpOperationsList.iterator();
            while (dlpOperationsIterator.hasNext()) {
                if (this.isInterrupted()) {
                    throw new RuntimeException("Dlp queue processing interrupted");
                }
                DlpOperation dlpOperation = (DlpOperation)dlpOperationsIterator.next();
                LOGGER.debug("Call processItem for dlpOperation {}", new Object[]{dlpOperation.toString()});
                if (!connector.processItem(dlpOperation.getEntityId())) continue;
                this.dlpOperationDAO.delete((Object)dlpOperation);
                --nbElementsStayingInQueue;
            }
        }
        return nbElementsStayingInQueue;
    }

    private void putDlpOperationInMemoryQueue(DlpOperation dlpOperation, Map<String, List<DlpOperation>> dlpQueueSorted) {
        if (!dlpQueueSorted.containsKey(dlpOperation.getEntityType())) {
            dlpQueueSorted.put(dlpOperation.getEntityType(), new ArrayList());
        }
        dlpQueueSorted.get(dlpOperation.getEntityType()).add(dlpOperation);
    }
}

