/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.activity.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

@Asynchronous
public class DlpActivityAttachmentListener
extends Listener<Object, Object> {
    private PortalContainer container;
    private CachedActivityStorage activityStorage;
    private DlpPositiveItemService dlpPositiveItemService;

    public DlpActivityAttachmentListener(DlpPositiveItemService dlpPositiveItemService, ActivityStorage activityStorage, PortalContainer container) {
        this.container = container;
        this.dlpPositiveItemService = dlpPositiveItemService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.activityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Object> event) throws Exception {
        if (this.activityStorage == null) {
            return;
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String attachmentId = null;
            if (event.getData() instanceof DlpPositiveItem) {
                DlpPositiveItem quarantineItem = (DlpPositiveItem)event.getData();
                attachmentId = quarantineItem.getReference();
            } else if (event.getData() instanceof DlpPositiveItemEntity) {
                DlpPositiveItemEntity quarantineItem = (DlpPositiveItemEntity)event.getData();
                if (quarantineItem == null || !StringUtils.equals((CharSequence)quarantineItem.getType(), (CharSequence)"file")) {
                    return;
                }
                attachmentId = quarantineItem.getReference();
            } else if (event.getData() instanceof Long) {
                long dlpItemId = (Long)event.getData();
                DlpPositiveItem quarantineItem = this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(dlpItemId));
                if (quarantineItem == null || !StringUtils.equals((CharSequence)quarantineItem.getType(), (CharSequence)"file")) {
                    return;
                }
                attachmentId = quarantineItem.getReference();
            } else if (event.getData() instanceof String) {
                String dlpItemReference = (String)event.getData();
                DlpPositiveItem quarantineItem = this.dlpPositiveItemService.getDlpPositiveItemByReference(dlpItemReference);
                if (quarantineItem == null || !StringUtils.equals((CharSequence)quarantineItem.getType(), (CharSequence)"file")) {
                    return;
                }
                attachmentId = quarantineItem.getReference();
            }
            if (!StringUtils.isBlank((CharSequence)attachmentId)) {
                this.activityStorage.clearActivityCachedByAttachmentId(attachmentId);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

