/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.channel.template;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="DlpUserDetectedItemPlugin", template="war:/intranet-notification/templates/DlpUserDetectedItemPlugin.gtmpl"), @TemplateConfig(pluginId="DlpAdminDetectedItemPlugin", template="war:/intranet-notification/templates/DlpAdminDetectedItemPlugin.gtmpl"), @TemplateConfig(pluginId="DlpUserRestoredItemPlugin", template="war:/intranet-notification/templates/DlpUserRestoredItemPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    private static final String IS_INTRANET = "isIntranet";
    private static final String READ = "READ";
    private static final String NOTIFICATION_ID = "NOTIFICATION_ID";
    private static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    private static final String ITEM_TITLE = "ITEM_TITLE";
    private static final String DLP_PAGE_URL = "DLP_PAGE_URL";
    private static final String ITEM_URL = "ITEM_URL";
    private static final String DATE_FORMAT = "EE, dd yyyy";
    private static final String ITEM_TITLE_NOTIFICATION_PARAM = "itemTitle";
    private static final String READ_NOTIFICATION_PARAM = "read";
    private static final String UNREAD_NOTIFICATION_PARAM = "unread";
    private AbstractTemplateBuilder dlpUserDetectedItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            templateContext.put((Object)WebTemplateProvider.IS_INTRANET, (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            Boolean read = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
            templateContext.put((Object)WebTemplateProvider.READ, (Object)read);
            templateContext.put((Object)WebTemplateProvider.NOTIFICATION_ID, (Object)notification.getId());
            templateContext.put((Object)WebTemplateProvider.LAST_UPDATED_TIME, (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)WebTemplateProvider.DATE_FORMAT, (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)WebTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(WebTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder dlpAdminDetectedItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            templateContext.put((Object)WebTemplateProvider.IS_INTRANET, (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)WebTemplateProvider.READ, (Object)(Boolean.TRUE.equals(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()))) ? WebTemplateProvider.READ_NOTIFICATION_PARAM : WebTemplateProvider.UNREAD_NOTIFICATION_PARAM));
            templateContext.put((Object)WebTemplateProvider.NOTIFICATION_ID, (Object)notification.getId());
            templateContext.put((Object)WebTemplateProvider.LAST_UPDATED_TIME, (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)WebTemplateProvider.DATE_FORMAT, (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)WebTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(WebTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            templateContext.put((Object)WebTemplateProvider.DLP_PAGE_URL, (Object)DlpUtils.getQuarantinePageUri());
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder dlpUserRestoredItem = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            templateContext.put((Object)WebTemplateProvider.IS_INTRANET, (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)WebTemplateProvider.READ, (Object)(Boolean.TRUE.equals(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()))) ? WebTemplateProvider.READ_NOTIFICATION_PARAM : WebTemplateProvider.UNREAD_NOTIFICATION_PARAM));
            templateContext.put((Object)WebTemplateProvider.NOTIFICATION_ID, (Object)notification.getId());
            templateContext.put((Object)WebTemplateProvider.LAST_UPDATED_TIME, (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)WebTemplateProvider.DATE_FORMAT, (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)WebTemplateProvider.ITEM_TITLE, (Object)notification.getValueOwnerParameter(WebTemplateProvider.ITEM_TITLE_NOTIFICATION_PARAM));
            templateContext.put((Object)WebTemplateProvider.ITEM_URL, (Object)DlpUtils.getDlpRestoredUri(notification.getValueOwnerParameter("itemReference")));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"DlpUserDetectedItemPlugin"), this.dlpUserDetectedItem);
        this.templateBuilders.put(PluginKey.key((String)"DlpAdminDetectedItemPlugin"), this.dlpAdminDetectedItem);
        this.templateBuilders.put(PluginKey.key((String)"DlpUserRestoredItemPlugin"), this.dlpUserRestoredItem);
    }
}

