/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.connector;

import com.google.common.annotations.VisibleForTesting;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.connector.DlpServiceConnector;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.domain.RestoredDlpItemEntity;
import org.exoplatform.dlp.dto.RestoredDlpItem;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.service.RestoredDlpItemService;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.connector.FileSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.router.Router;

public class FileDlpConnector
extends DlpServiceConnector {
    public static final String TYPE = "file";
    public static final String DLP_QUARANTINE_FOLDER = "Quarantine";
    public static final String EXO_CURRENT_PROVIDER = "exo:currentProvider";
    private static final Log LOGGER = ExoLogger.getExoLogger(FileDlpConnector.class);
    private static final String COLLABORATION_WS = "collaboration";
    private RepositoryService repositoryService;
    public static final String EXO_RESTORE_LOCATION = "exo:restoreLocation";
    public static final String RESTORE_PATH = "exo:restorePath";
    public static final String EXO_DLP_ITEM_MIXIN = "exo:exoDlpItem";
    private IndexingService indexingService;
    private FileSearchServiceConnector fileSearchServiceConnector;
    private RestoredDlpItemService restoredDlpItemService;
    private DlpOperationProcessor dlpOperationProcessor;
    private TrashService trashService;
    private LinkManager linkManager;

    public FileDlpConnector(InitParams initParams, FileSearchServiceConnector fileSearchServiceConnector, RepositoryService repositoryService, IndexingService indexingService, DlpOperationProcessor dlpOperationProcessor, RestoredDlpItemService restoredDlpItemService, LinkManager linkManager, TrashService trashService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.indexingService = indexingService;
        this.fileSearchServiceConnector = fileSearchServiceConnector;
        this.restoredDlpItemService = restoredDlpItemService;
        this.dlpOperationProcessor = dlpOperationProcessor;
        this.linkManager = linkManager;
        this.trashService = trashService;
    }

    @Override
    public boolean processItem(String entityId) {
        LOGGER.debug("Process item {}", new Object[]{entityId});
        if (!this.itemExist(entityId) || this.isInTrash(entityId)) {
            return true;
        }
        if (!this.isIndexedByEs(entityId) || this.editorOpened(entityId)) {
            return false;
        }
        this.checkMatchKeywordAndTreatItem(entityId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean itemExist(String entityId) {
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node item = session.getNodeByIdentifier(entityId);
            LOGGER.debug("Item {} exists, path={}", new Object[]{entityId, item.getPath()});
            boolean bl = true;
            return bl;
        }
        catch (ItemNotFoundException e) {
            LOGGER.debug("Item {} not exists", new Object[]{entityId});
            boolean bl = false;
            return bl;
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)"Error when reading repository", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInTrash(String entityId) {
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(entityId);
            boolean result = this.trashService.isInTrash(node);
            LOGGER.debug("Item {} isInTrash={}", new Object[]{entityId, result});
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error when check if node {} is in trash", new Object[]{entityId, e});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restorePositiveItem(String itemReference) {
        ExtendedSession session = null;
        try {
            long startTime = System.currentTimeMillis();
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(itemReference);
            String fileName = node.getName();
            this.removeMixinForRestoredItemSymlinks(node);
            this.restoreFromQuarantine(node.getPath());
            this.indexingService.reindex(TYPE, itemReference);
            this.saveRestoredDlpItem(node.getUUID());
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOGGER.info("service={} operation={} parameters=\"fileName:{}\" status=ok duration_ms={}", new Object[]{"dlp", "restoreDLPItem", fileName, totalTime});
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while treating file dlp connector item", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private boolean isIndexedByEs(String entityId) {
        SearchContext searchContext = null;
        try {
            searchContext = new SearchContext(new Router(new ControllerDescriptor()), "");
            boolean result = this.fileSearchServiceConnector.isIndexed(searchContext, entityId);
            LOGGER.debug("Item {} isindexedByEs={}", new Object[]{entityId, result});
            return result;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Can not create SearchContext", (Throwable)ex);
            return false;
        }
    }

    private void checkMatchKeywordAndTreatItem(String entityId) {
        SearchContext searchContext = null;
        String dlpKeywords = this.dlpOperationProcessor.getKeywords();
        if (dlpKeywords != null && !dlpKeywords.isEmpty()) {
            try {
                searchContext = new SearchContext(new Router(new ControllerDescriptor()), "");
                Collection searchResults = this.fileSearchServiceConnector.searchByEntityId(searchContext, dlpKeywords, entityId);
                if (!this.getDetectedKeywords(searchResults, this.dlpOperationProcessor.getKeywords()).isEmpty()) {
                    this.treatItem(entityId, searchResults);
                } else {
                    LOGGER.debug("Item {} does not match keywords", new Object[]{entityId});
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Can not create SearchContext", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void treatItem(String entityId, Collection<SearchResult> searchResults) {
        ExtendedSession session = null;
        try {
            long startTime = System.currentTimeMillis();
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Workspace workspace = session.getWorkspace();
            Node node = session.getNodeByIdentifier(entityId);
            String fileName = node.getName();
            String restorePath = this.fixRestorePath(node.getPath());
            RestoredDlpItem restoredDlpItem = this.findRestoredDlpItem(node.getUUID());
            if (!(node.getPath().startsWith("/Quarantine/") || restoredDlpItem != null && this.getNodeLastModifiedDate(node) <= restoredDlpItem.getDetectionDate())) {
                LOGGER.debug("Item {} is put in DLP quarantine", new Object[]{entityId});
                this.addMixinForRestoredItemSymlinks(node);
                workspace.move(node.getPath(), "/Quarantine/" + fileName);
                this.indexingService.unindex(TYPE, entityId);
                this.saveDlpPositiveItem(node, searchResults);
                this.addRestorePathInfo(node.getName(), restorePath);
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                LOGGER.info("service={} operation={} parameters=\"fileName:{}\" status=ok duration_ms={}", new Object[]{"dlp", "dlpPositiveDetection", fileName, totalTime});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while treating file dlp connector item", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private Long getNodeLastModifiedDate(Node node) throws Exception {
        Calendar calendar = node.hasProperty("exo:lastModifiedDate") ? node.getProperty("exo:lastModifiedDate").getDate() : node.getProperty("exo:dateCreated").getDate();
        return calendar.getTimeInMillis();
    }

    private void saveDlpPositiveItem(Node node, Collection<SearchResult> searchResults) throws Exception {
        DlpPositiveItemService dlpPositiveItemService = (DlpPositiveItemService)CommonsUtils.getService(DlpPositiveItemService.class);
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setReference(node.getUUID());
        if (node.hasProperty("exo:title")) {
            String title = node.getProperty("exo:title").getString();
            dlpPositiveItemEntity.setTitle(URLDecoder.decode(title, "UTF-8"));
        }
        if (node.hasProperty("exo:lastModifier")) {
            String author = node.getProperty("exo:lastModifier").getString();
            dlpPositiveItemEntity.setAuthor(author);
        }
        dlpPositiveItemEntity.setType(TYPE);
        dlpPositiveItemEntity.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity.setKeywords(this.getDetectedKeywords(searchResults, this.dlpOperationProcessor.getKeywords()));
        dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePositiveItem(String itemReference) {
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node dlpQuarantineNode = (Node)session.getItem("/Quarantine");
            Node node = session.getNodeByIdentifier(itemReference);
            if (node != null && dlpQuarantineNode != null) {
                Utils.removeDeadSymlinks((Node)node, (boolean)false);
                node.remove();
                dlpQuarantineNode.save();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while deleting dlp file item", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean checkExternal(String userId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", userId);
        return identity.getProfile().getProperty("external") != null && identity.getProfile().getProperty("external").equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getItemUrl(String itemReference) {
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(itemReference);
            String string = WCMCoreUtils.getLinkInDocumentsApplication((String)node.getPath());
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting dlp item url, itemId={}", new Object[]{itemReference, e});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    private String getDetectedKeywords(Collection<SearchResult> searchResults, String dlpKeywords) {
        ArrayList detectedKeywords = new ArrayList();
        List<String> dlpKeywordsList = Arrays.asList(dlpKeywords.split(","));
        searchResults.stream().map(SearchResult::getExcerpts).map(Map::values).filter(excerptValue -> !excerptValue.isEmpty()).flatMap(Collection::stream).flatMap(Collection::stream).forEach(s -> dlpKeywordsList.stream().filter(key -> this.removeAccents((String)s).contains(this.escapeSpecialCharacters(this.removeAccents((String)key))) || this.removeAccents((String)s).contains((CharSequence)key)).forEach(key -> {
            if (!key.isEmpty() && !detectedKeywords.contains(key)) {
                detectedKeywords.add(key);
            }
        }));
        return detectedKeywords.stream().collect(Collectors.joining(", "));
    }

    private String escapeSpecialCharacters(String keyword) {
        List keywordParts = Arrays.stream(keyword.split("[+\\-=&|><!(){}\\[\\]^\"*?:/ @$#]+")).distinct().collect(Collectors.toList());
        for (String s : keywordParts) {
            keyword = keyword.replace(s, "<em>" + s + "</em>");
        }
        return keyword.replace("'", "\u2019");
    }

    private void saveRestoredDlpItem(String nodeUID) {
        RestoredDlpItemEntity restoredDlpItemEntity = new RestoredDlpItemEntity();
        restoredDlpItemEntity.setReference(nodeUID);
        restoredDlpItemEntity.setDetectionDate(Calendar.getInstance());
        this.restoredDlpItemService.addRestoredDlpItem(restoredDlpItemEntity);
    }

    private RestoredDlpItem findRestoredDlpItem(String nodeUID) throws Exception {
        return this.restoredDlpItemService.getRestoredDlpItemByReference(nodeUID);
    }

    private void addRestorePathInfo(String nodeName, String restorePath) throws Exception {
        NodeIterator nodes = Objects.requireNonNull(this.getQuarantineHomeNode()).getNodes(nodeName);
        Node node = null;
        while (nodes.hasNext()) {
            Node currentNode = nodes.nextNode();
            if (node == null) {
                node = currentNode;
                continue;
            }
            if (node.getIndex() >= currentNode.getIndex()) continue;
            node = currentNode;
        }
        if (node != null) {
            node.addMixin(EXO_RESTORE_LOCATION);
            node.setProperty(RESTORE_PATH, restorePath);
            node.save();
        }
    }

    private Node getQuarantineHomeNode() {
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            return (Node)session.getItem("/Quarantine");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String fixRestorePath(String path) {
        int leftBracket = path.lastIndexOf(91);
        int rightBracket = path.lastIndexOf(93);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(leftBracket + 1, rightBracket));
        }
        catch (Exception ex) {
            return path;
        }
        return path.substring(0, leftBracket);
    }

    private void restoreFromQuarantine(String securityNodePath) throws Exception {
        Node securityHomeNode = this.getQuarantineHomeNode();
        if (securityHomeNode == null) {
            return;
        }
        Session restoreSession = securityHomeNode.getSession();
        Node securityNode = (Node)restoreSession.getItem(securityNodePath);
        String restorePath = securityNode.getProperty(RESTORE_PATH).getString();
        restoreSession.getWorkspace().move(securityNodePath, restorePath);
        if (securityNode.hasProperty("exo:lastModifier")) {
            restoreSession.getNodeByUUID(securityNode.getUUID()).setProperty("exo:lastModifier", securityNode.getProperty("exo:lastModifier").getString());
        }
        this.removeRestorePathInfo(restoreSession, restorePath);
        securityHomeNode.save();
        restoreSession.save();
    }

    private void removeRestorePathInfo(Session session, String restorePath) throws Exception {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType(EXO_RESTORE_LOCATION)) continue;
            node.removeMixin(EXO_RESTORE_LOCATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean editorOpened(String entityId) {
        Node node = null;
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            node = session.getNodeByIdentifier(entityId);
            boolean result = node.hasProperty(EXO_CURRENT_PROVIDER);
            LOGGER.debug("Item {} isEditorOpened={}", new Object[]{entityId, result});
            boolean bl = result;
            return bl;
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)"Error while checking editor status", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    private String removeAccents(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        }
        try {
            return URLDecoder.decode(string.toLowerCase(), "UTF-8");
        }
        catch (Exception e) {
            return string.toLowerCase();
        }
    }

    private void addMixinForRestoredItemSymlinks(Node node) throws Exception {
        List itemLinks = this.linkManager.getAllLinks(node, "exo:symlink", WCMCoreUtils.getSystemSessionProvider());
        if (itemLinks != null && !itemLinks.isEmpty()) {
            for (Node nodeLink : itemLinks) {
                nodeLink.addMixin(EXO_DLP_ITEM_MIXIN);
                nodeLink.save();
            }
        }
    }

    private void removeMixinForRestoredItemSymlinks(Node node) throws Exception {
        List itemLinks = this.linkManager.getAllLinks(node, "exo:symlink", WCMCoreUtils.getSystemSessionProvider());
        if (itemLinks != null && !itemLinks.isEmpty()) {
            for (Node nodeLink : itemLinks) {
                nodeLink.removeMixin(EXO_DLP_ITEM_MIXIN);
                nodeLink.save();
            }
        }
    }
}

