/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.dao;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.dao.DlpOperationDAO;
import org.exoplatform.dlp.domain.DlpOperation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DlpOperationDAOTest {
    private DlpOperationDAO dlpOperationDAO;

    @Before
    public void setUp() {
        PortalContainer container = PortalContainer.getInstance();
        this.dlpOperationDAO = (DlpOperationDAO)container.getComponentInstanceOfType(DlpOperationDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    @After
    public void tearDown() {
        this.dlpOperationDAO.deleteAll();
        RequestLifeCycle.end();
    }

    @Test
    public void testDlpQueueCreation() throws IllegalAccessException, NoSuchFieldException {
        List dlpOperations = this.dlpOperationDAO.findAll();
        Assert.assertEquals((long)0L, (long)dlpOperations.size());
        this.createDlpOperations();
        Assert.assertEquals((long)3L, (long)this.dlpOperationDAO.findAll().size());
        dlpOperations = this.dlpOperationDAO.findAll();
        Field privateField = DlpOperation.class.getDeclaredField("timestamp");
        privateField.setAccessible(true);
        Date timestamp = (Date)privateField.get(dlpOperations.get(0));
        Assert.assertNull((Object)timestamp);
    }

    @Test
    public void testFindByEntityIdAndType() {
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findByEntityIdAndType("1", "file").size());
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findByEntityIdAndType("100", "file").size());
        this.createDlpOperations();
        Assert.assertEquals((long)3L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)1L, (long)this.dlpOperationDAO.findByEntityIdAndType("1", "file").size());
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findByEntityIdAndType("100", "file").size());
    }

    @Test
    public void testFindAllFirst() {
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findAllFirstWithOffset(0, 2).size());
        this.createDlpOperations();
        Assert.assertEquals((long)3L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)2L, (long)this.dlpOperationDAO.findAllFirstWithOffset(0, 2).size());
        Assert.assertEquals((Object)"22", (Object)((DlpOperation)this.dlpOperationDAO.findAllFirstWithOffset(0, 2).get(1)).getEntityId());
        Assert.assertEquals((Object)"22", (Object)((DlpOperation)this.dlpOperationDAO.findAllFirstWithOffset(1, 2).get(0)).getEntityId());
        Assert.assertEquals((Object)"100", (Object)((DlpOperation)this.dlpOperationDAO.findAllFirstWithOffset(1, 2).get(1)).getEntityId());
    }

    @Test
    public void testDeleteByEntityId() {
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findAllFirstWithOffset(0, 2).size());
        this.createDlpOperations();
        this.createDlpOperations();
        Assert.assertEquals((long)6L, (long)this.dlpOperationDAO.findAll().size());
        Assert.assertEquals((long)2L, (long)this.dlpOperationDAO.findByEntityIdAndType("22", "file").size());
        this.dlpOperationDAO.deleteByEntityId("22");
        Assert.assertEquals((long)0L, (long)this.dlpOperationDAO.findByEntityIdAndType("22", "file").size());
        Assert.assertEquals((long)4L, (long)this.dlpOperationDAO.findAll().size());
    }

    private void createDlpOperations() {
        DlpOperation dlpOperation = new DlpOperation();
        dlpOperation.setEntityType("file");
        dlpOperation.setEntityId("1");
        this.dlpOperationDAO.create((Object)dlpOperation);
        dlpOperation = new DlpOperation();
        dlpOperation.setEntityType("file");
        dlpOperation.setEntityId("22");
        this.dlpOperationDAO.create((Object)dlpOperation);
        dlpOperation = new DlpOperation();
        dlpOperation.setEntityType("activity");
        dlpOperation.setEntityId("100");
        this.dlpOperationDAO.create((Object)dlpOperation);
    }
}

