/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.notification.plugin.DlpUserDetectedItemPlugin;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpUserDetectedItemPluginTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private DlpPositiveItemService dlpPositiveItemService;
    @Mock
    private InitParams initParams;
    private DlpUserDetectedItemPlugin dlpUserDetectedItemPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.dlpUserDetectedItemPlugin = new DlpUserDetectedItemPlugin(this.initParams, this.dlpPositiveItemService);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void makeNotification() throws Exception {
        DlpPositiveItem dlpPositiveItem = new DlpPositiveItem();
        dlpPositiveItem.setAuthor("author");
        dlpPositiveItem.setTitle("file.docx");
        dlpPositiveItem.setAuthorDisplayName("user author");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(new ArgumentLiteral(Long.class, "dlp_detected_item_id"), (Object)1L);
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(1L))).thenReturn((Object)dlpPositiveItem);
        NotificationInfo notificationInfo = this.dlpUserDetectedItemPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"file.docx", (Object)notificationInfo.getValueOwnerParameter("itemTitle"));
        Assert.assertEquals((Object)"user author", (Object)notificationInfo.getValueOwnerParameter("itemAuthor"));
        Assert.assertEquals((Object)"author", (Object)notificationInfo.getTo());
    }
}

