/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.service;

import java.util.Calendar;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.dao.RestoredDlpItemDAO;
import org.exoplatform.dlp.domain.RestoredDlpItemEntity;
import org.exoplatform.dlp.dto.RestoredDlpItem;
import org.exoplatform.dlp.service.RestoredDlpItemServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RestoredDlpItemServiceTest {
    private RestoredDlpItemDAO restoredDlpItemDAO;
    private RestoredDlpItemServiceImpl restoredDlpItemService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PortalContainer container = PortalContainer.getInstance();
        this.restoredDlpItemDAO = (RestoredDlpItemDAO)container.getComponentInstanceOfType(RestoredDlpItemDAO.class);
        this.restoredDlpItemService = new RestoredDlpItemServiceImpl(this.restoredDlpItemDAO);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    @Test
    public void testGetRestoredDlpItemByReference() {
        RestoredDlpItemEntity restoredDlpItemEntity = new RestoredDlpItemEntity();
        restoredDlpItemEntity.setReference("nodeUID");
        restoredDlpItemEntity.setDetectionDate(Calendar.getInstance());
        this.restoredDlpItemService.addRestoredDlpItem(restoredDlpItemEntity);
        RestoredDlpItem restoredDlpItem = this.restoredDlpItemService.getRestoredDlpItemByReference("nodeUID");
        Assert.assertNotNull((Object)restoredDlpItem);
    }

    @After
    public void tearDown() {
        this.restoredDlpItemDAO.deleteAll();
        RequestLifeCycle.end();
    }
}

