/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.utils.DlpUtils;

public class DlpUserDetectedItemPlugin
extends BaseNotificationPlugin {
    public static final String ID = "DlpUserDetectedItemPlugin";
    private DlpPositiveItemService dlpPositiveItemService;

    public DlpUserDetectedItemPlugin(InitParams initParams, DlpPositiveItemService dlpPositiveItemService) {
        super(initParams);
        this.dlpPositiveItemService = dlpPositiveItemService;
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        long dlpItemId = (Long)ctx.value(DlpUtils.DLP_DETECTED_ITEM_ID);
        DlpPositiveItem dlpPositiveItem = null;
        try {
            dlpPositiveItem = this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(dlpItemId));
            return NotificationInfo.instance().key(this.getId()).with("itemTitle", dlpPositiveItem.getTitle()).with("itemAuthor", dlpPositiveItem.getAuthorDisplayName()).to(dlpPositiveItem.getAuthor());
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

