/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.dao;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.dao.DlpPositiveItemDAO;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DlpPositiveItemDAOTest {
    private DlpPositiveItemDAO dlpPositiveItemDAO;

    @Before
    public void setUp() {
        PortalContainer container = PortalContainer.getInstance();
        this.dlpPositiveItemDAO = (DlpPositiveItemDAO)container.getComponentInstanceOfType(DlpPositiveItemDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        this.dlpPositiveItemDAO.deleteAll();
    }

    @After
    public void tearDown() {
        this.dlpPositiveItemDAO.deleteAll();
        RequestLifeCycle.end();
    }

    @Test
    public void testDlpPositiveItemsCreation() {
        List dlpPositiveItemEntities = this.dlpPositiveItemDAO.getDlpPositiveItems(0, 20);
        Assert.assertEquals((long)0L, (long)dlpPositiveItemEntities.size());
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity);
        DlpPositiveItemEntity dlpPositiveItemEntity1 = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file1");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity1);
        DlpPositiveItemEntity dlpPositiveItemEntity2 = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file2");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity2);
        dlpPositiveItemEntities = this.dlpPositiveItemDAO.getDlpPositiveItems(0, 20);
        Assert.assertEquals((long)3L, (long)dlpPositiveItemEntities.size());
    }

    @Test
    public void testFindDlpPositiveItemByReference() {
        Assert.assertEquals((long)0L, (long)this.dlpPositiveItemDAO.findAll().size());
        Assert.assertNull((Object)this.dlpPositiveItemDAO.findDlpPositiveItemByReference("ref1"));
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        dlpPositiveItemEntity.setReference("ref1");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity);
        Assert.assertNotNull((Object)this.dlpPositiveItemDAO.findDlpPositiveItemByReference("ref1"));
    }

    @Test
    public void testDeleteDlpPositiveItemByReference() {
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        dlpPositiveItemEntity.setReference("ref1");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity);
        Assert.assertEquals((long)1L, (long)this.dlpPositiveItemDAO.count().intValue());
        this.dlpPositiveItemDAO.delete((Object)dlpPositiveItemEntity);
        Assert.assertEquals((long)0L, (long)this.dlpPositiveItemDAO.count().intValue());
    }

    @Test
    public void testDlpPositiveItemsCreationWithLongKeyword() {
        List dlpPositiveItemEntities = this.dlpPositiveItemDAO.getDlpPositiveItems(0, 20);
        Assert.assertEquals((long)0L, (long)dlpPositiveItemEntities.size());
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        dlpPositiveItemEntity.setKeywords("keyword1, keyword2, keyword3, keyword4, keyword5, keyword6");
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity);
        dlpPositiveItemEntities = this.dlpPositiveItemDAO.getDlpPositiveItems(0, 20);
        Assert.assertEquals((long)1L, (long)dlpPositiveItemEntities.size());
    }
}

