/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.queue;

import org.exoplatform.dlp.dao.DlpOperationDAO;
import org.exoplatform.dlp.domain.DlpOperation;
import org.exoplatform.dlp.queue.impl.QueueDlpServiceImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueueDlpServiceTest {
    private QueueDlpServiceImpl queueDlpService;
    @Mock
    private DlpOperationDAO dlpOperationDAO;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        this.queueDlpService = new QueueDlpServiceImpl(this.dlpOperationDAO);
    }

    @Test
    public void testAddToQueue() {
        DlpOperation dlpOperation = new DlpOperation("100", "file");
        this.queueDlpService.addToQueue("file", dlpOperation.getEntityId());
        ((DlpOperationDAO)Mockito.verify((Object)this.dlpOperationDAO, (VerificationMode)Mockito.times((int)1))).create((Object)dlpOperation);
    }

    @Test
    public void testRemoveFromQueue() {
        DlpOperation dlpOperation = new DlpOperation("100", "file");
        DlpOperation dlpOperation2 = new DlpOperation("101", "file");
        DlpOperation dlpOperation3 = new DlpOperation("100", "file");
        this.queueDlpService.addToQueue("file", dlpOperation.getEntityId());
        this.queueDlpService.addToQueue("file", dlpOperation2.getEntityId());
        this.queueDlpService.addToQueue("file", dlpOperation3.getEntityId());
        this.queueDlpService.removeAllItemFromQueue("100");
        ((DlpOperationDAO)Mockito.verify((Object)this.dlpOperationDAO, (VerificationMode)Mockito.times((int)1))).deleteByEntityId("100");
    }
}

