/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.service;

import java.io.Serializable;
import java.util.Calendar;
import org.exoplatform.dlp.dao.RestoredDlpItemDAO;
import org.exoplatform.dlp.domain.RestoredDlpItemEntity;
import org.exoplatform.dlp.dto.RestoredDlpItem;
import org.exoplatform.dlp.service.RestoredDlpItemService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RestoredDlpItemServiceImpl
implements RestoredDlpItemService {
    private static final Log LOG = ExoLogger.getLogger(RestoredDlpItemServiceImpl.class);
    private final RestoredDlpItemDAO restoredDlpItemDAO;

    public RestoredDlpItemServiceImpl(RestoredDlpItemDAO restoredDlpItemDAO) {
        this.restoredDlpItemDAO = restoredDlpItemDAO;
    }

    public void addRestoredDlpItem(RestoredDlpItemEntity restoredDlpItemEntity) {
        RestoredDlpItemEntity existedEntity = this.restoredDlpItemDAO.findRestoredDlpItemByReference(restoredDlpItemEntity.getReference());
        if (existedEntity != null) {
            existedEntity.setDetectionDate(Calendar.getInstance());
            this.restoredDlpItemDAO.update((Object)existedEntity);
        } else {
            this.restoredDlpItemDAO.create((Object)restoredDlpItemEntity);
        }
    }

    public void deleteRestoredDlpItem(Long itemId) {
        RestoredDlpItemEntity restoredDlpItemEntity = (RestoredDlpItemEntity)this.restoredDlpItemDAO.find((Serializable)itemId);
        if (restoredDlpItemEntity != null) {
            this.restoredDlpItemDAO.delete((Object)restoredDlpItemEntity);
        }
    }

    public RestoredDlpItem getRestoredDlpItemByReference(String itemReference) {
        RestoredDlpItemEntity restoredDlpItemEntity = this.restoredDlpItemDAO.findRestoredDlpItemByReference(itemReference);
        try {
            return this.fillRestoredDlpItemFromEntity(restoredDlpItemEntity);
        }
        catch (Exception e) {
            LOG.warn("The restored Dlp Item's {} not found.", new Object[]{itemReference});
            return null;
        }
    }

    private RestoredDlpItem fillRestoredDlpItemFromEntity(RestoredDlpItemEntity restoredDlpItemEntity) {
        RestoredDlpItem restoredDlpItem = new RestoredDlpItem();
        restoredDlpItem.setId(restoredDlpItemEntity.getId());
        restoredDlpItem.setReference(restoredDlpItemEntity.getReference());
        restoredDlpItem.setDetectionDate(Long.valueOf(restoredDlpItemEntity.getDetectionDate().getTimeInMillis()));
        return restoredDlpItem;
    }
}

