/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class PositiveItemDlpListener
extends Listener<DlpPositiveItemService, Object> {
    public static final String DLP_DETECT_ITEM_EVENT = "dlp.listener.event.detect.item";
    public static final String DLP_RESTORE_ITEM_EVENT = "dlp.listener.event.restore.item";

    public void onEvent(Event<DlpPositiveItemService, Object> event) {
        if (DLP_DETECT_ITEM_EVENT.equals(event.getEventName())) {
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(DlpUtils.DLP_DETECTED_ITEM_ID, event.getData());
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"DlpUserDetectedItemPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"DlpAdminDetectedItemPlugin"))).execute(ctx);
        } else if (DLP_RESTORE_ITEM_EVENT.equals(event.getEventName())) {
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(DlpUtils.DLP_RESTORED_ITEM_TITLE, (Object)((DlpPositiveItemEntity)event.getData()).getTitle()).append(DlpUtils.DLP_RESTORED_ITEM_AUTHOR, (Object)((DlpPositiveItemEntity)event.getData()).getAuthor()).append(DlpUtils.DLP_RESTORED_ITEM_REFERENCE, (Object)((DlpPositiveItemEntity)event.getData()).getReference());
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"DlpUserRestoredItemPlugin"))).execute(ctx);
        }
    }
}

