/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.rest;

import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.dlp.rest.DlpRestServices;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.portal.config.UserACL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpRestServicesTest {
    private static final MockedStatic<DlpUtils> DLP_UTILS = Mockito.mockStatic(DlpUtils.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private DlpRestServices dlpRestServices;
    @Mock
    private UserACL userACL;

    @AfterClass
    public static void afterRunBare() {
        DLP_UTILS.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() {
        this.dlpRestServices = new DlpRestServices();
        COMMONS_UTILS.when(() -> CommonsUtils.getService(UserACL.class)).thenReturn((Object)this.userACL);
    }

    @Test
    public void changeFeatureActivation() {
        ExoFeatureService exoFeatureService = (ExoFeatureService)Mockito.mock(ExoFeatureService.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ExoFeatureService.class)).thenReturn((Object)exoFeatureService);
        DLP_UTILS.when(DlpUtils::isDlpAdmin).thenReturn((Object)false);
        Response response = this.dlpRestServices.changeFeatureActivation("false");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(DlpUtils::isDlpAdmin).thenReturn((Object)true);
        Response response1 = this.dlpRestServices.changeFeatureActivation("true");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((ExoFeatureService)Mockito.verify((Object)exoFeatureService, (VerificationMode)Mockito.times((int)1))).saveActiveFeature("dlp", true);
        ((ExoFeatureService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)exoFeatureService)).saveActiveFeature("dlp", true);
        Response response2 = this.dlpRestServices.changeFeatureActivation("true");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }
}

