/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.service;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.connector.DlpServiceConnector;
import org.exoplatform.dlp.dao.DlpOperationDAO;
import org.exoplatform.dlp.dao.DlpPositiveItemDAO;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.processor.impl.DlpOperationProcessorImpl;
import org.exoplatform.dlp.service.DlpPositiveItemServiceImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpPositiveItemServiceTest {
    @Mock
    private DlpOperationDAO dlpOperationDAO;
    private DlpOperationProcessorImpl dlpOperationProcessor;
    private DlpPositiveItemDAO dlpPositiveItemDAO;
    private DlpPositiveItemServiceImpl dlpPositiveItemService;
    private DlpServiceConnector dlpServiceConnector;
    @Mock
    private DlpServiceConnector dlpServiceConnector1;
    @Mock
    private DlpServiceConnector dlpServiceConnector2;
    @Mock
    private ListenerService listenerService;
    private OrganizationService organizationService;
    private UserHandler userHandler;

    @After
    public void clean() {
        this.dlpOperationProcessor.getConnectors().clear();
        this.dlpPositiveItemDAO.deleteAll();
        RequestLifeCycle.end();
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        this.dlpServiceConnector = (DlpServiceConnector)Mockito.mock(DlpServiceConnector.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        this.userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        UserImpl user = new UserImpl();
        user.setUserName("root");
        user.setFullName("root root");
        Mockito.when((Object)this.userHandler.findUserByName("root")).thenReturn((Object)user);
        PortalContainer container = PortalContainer.getInstance();
        this.dlpPositiveItemDAO = (DlpPositiveItemDAO)container.getComponentInstanceOfType(DlpPositiveItemDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        this.initDlpServiceConnector();
        this.dlpOperationProcessor = new DlpOperationProcessorImpl(this.dlpOperationDAO);
        this.dlpPositiveItemService = new DlpPositiveItemServiceImpl(this.dlpPositiveItemDAO, this.organizationService, this.listenerService, (DlpOperationProcessor)this.dlpOperationProcessor);
    }

    private void initDlpServiceConnector() {
        Mockito.when((Object)this.dlpServiceConnector.getType()).thenReturn((Object)"file");
        Mockito.when((Object)this.dlpServiceConnector.getDisplayName()).thenReturn((Object)"file");
        Mockito.when((Object)this.dlpServiceConnector.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)this.dlpServiceConnector.getItemUrl("reference1234")).thenReturn((Object)"/Security/file");
        Mockito.when((Object)this.dlpServiceConnector.getType()).thenReturn((Object)"file");
        Mockito.lenient().when((Object)this.dlpServiceConnector.getDisplayName()).thenReturn((Object)"file");
        Mockito.lenient().when((Object)this.dlpServiceConnector.isEnable()).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.dlpServiceConnector.getItemUrl("ref")).thenReturn((Object)"/Security/file12");
        Mockito.when((Object)this.dlpServiceConnector1.getType()).thenReturn((Object)"file1");
        Mockito.lenient().when((Object)this.dlpServiceConnector1.getDisplayName()).thenReturn((Object)"file1");
        Mockito.lenient().when((Object)this.dlpServiceConnector1.isEnable()).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.dlpServiceConnector1.getItemUrl("ref1")).thenReturn((Object)"/Security/file123");
        Mockito.when((Object)this.dlpServiceConnector2.getType()).thenReturn((Object)"file2");
        Mockito.lenient().when((Object)this.dlpServiceConnector2.getDisplayName()).thenReturn((Object)"file2");
        Mockito.lenient().when((Object)this.dlpServiceConnector2.isEnable()).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.dlpServiceConnector2.getItemUrl("ref2")).thenReturn((Object)"/Security/file1234");
    }

    @Test
    public void testGetDlpPositiveItemByReference() throws Exception {
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        dlpPositiveItemEntity.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity.setAuthor("root");
        dlpPositiveItemEntity.setKeywords("test1");
        dlpPositiveItemEntity.setReference("reference1234");
        this.dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity);
        this.dlpOperationProcessor.addConnector(this.dlpServiceConnector);
        DlpPositiveItem dlpPositiveItem = this.dlpPositiveItemService.getDlpPositiveItemByReference("reference1234");
        Assert.assertNotNull((Object)dlpPositiveItem);
    }

    @Test
    public void testGetDlpPositivesItems() throws Exception {
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setType("file");
        dlpPositiveItemEntity.setTitle("file");
        dlpPositiveItemEntity.setReference("ref");
        dlpPositiveItemEntity.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity.setAuthor("root");
        dlpPositiveItemEntity.setKeywords("Keywords");
        DlpPositiveItemEntity dlpPositiveItemEntity1 = new DlpPositiveItemEntity();
        dlpPositiveItemEntity1.setType("file1");
        dlpPositiveItemEntity1.setTitle("file1");
        dlpPositiveItemEntity1.setReference("ref1");
        dlpPositiveItemEntity1.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity1.setAuthor("root");
        dlpPositiveItemEntity.setKeywords("Keywords1");
        DlpPositiveItemEntity dlpPositiveItemEntity2 = new DlpPositiveItemEntity();
        dlpPositiveItemEntity2.setType("file2");
        dlpPositiveItemEntity2.setTitle("file2");
        dlpPositiveItemEntity2.setReference("ref2");
        dlpPositiveItemEntity2.setDetectionDate(Calendar.getInstance());
        dlpPositiveItemEntity2.setAuthor("root");
        dlpPositiveItemEntity.setKeywords("Keywords2");
        this.dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity);
        this.dlpOperationProcessor.addConnector(this.dlpServiceConnector);
        this.dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity1);
        this.dlpOperationProcessor.addConnector(this.dlpServiceConnector1);
        this.dlpPositiveItemService.addDlpPositiveItem(dlpPositiveItemEntity2);
        this.dlpOperationProcessor.addConnector(this.dlpServiceConnector2);
        List dlpPositiveItems = this.dlpPositiveItemService.getDlpPositivesItems(0, 20);
        Long size = this.dlpPositiveItemService.getDlpPositiveItemsCount();
        Assert.assertNotNull((Object)dlpPositiveItems);
        Assert.assertEquals((long)3L, (long)size.intValue());
        this.dlpPositiveItemService.deleteDlpPositiveItem(((DlpPositiveItem)dlpPositiveItems.get(0)).getId());
        size = this.dlpPositiveItemService.getDlpPositiveItemsCount();
        Assert.assertEquals((long)2L, (long)size.intValue());
    }
}

