/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.connector;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.dlp.connector.FileDlpConnector;
import org.exoplatform.dlp.domain.RestoredDlpItemEntity;
import org.exoplatform.dlp.dto.RestoredDlpItem;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.service.RestoredDlpItemService;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.search.connector.FileSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FileDlpConnectorTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<WCMCoreUtils> WCM_CORE_UTILS = Mockito.mockStatic(WCMCoreUtils.class);
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private IndexingService indexingService;
    @Mock
    private FileSearchServiceConnector fileSearchServiceConnector;
    @Mock
    private RestoredDlpItemService restoredDlpItemService;
    @Mock
    private DlpOperationProcessor dlpOperationProcessor;
    @Mock
    private TrashService trashService;
    @Mock
    private LinkManager linkManager;
    private FileDlpConnector fileDlpConnector;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
        WCM_CORE_UTILS.close();
        UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        InitParams params = new InitParams();
        PropertiesParam constructorParams = new PropertiesParam();
        constructorParams.setName("constructor.params");
        constructorParams.setProperty("type", "file");
        constructorParams.setProperty("enabled", "true");
        constructorParams.setProperty("displayName", "file");
        params.addParameter((Parameter)constructorParams);
        this.fileDlpConnector = new FileDlpConnector(params, this.fileSearchServiceConnector, this.repositoryService, this.indexingService, this.dlpOperationProcessor, this.restoredDlpItemService, this.linkManager, this.trashService);
    }

    @Test
    public void processItem() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node item = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getNodeByIdentifier("1")).thenReturn((Object)item);
        Mockito.when((Object)this.fileSearchServiceConnector.isIndexed((SearchContext)Mockito.any(), Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.trashService.isInTrash((Node)Mockito.any())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.fileDlpConnector.processItem("1"));
        Mockito.when((Object)this.trashService.isInTrash((Node)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)this.dlpOperationProcessor.getKeywords()).thenReturn((Object)"test");
        SearchResult searchResult = new SearchResult("url", "title", "test", "detail", "imageUri", 1321332L, 1L);
        searchResult.setExcerpts(Map.of("title", List.of("test")));
        Mockito.when((Object)this.fileSearchServiceConnector.searchByEntityId((SearchContext)Mockito.any(), Mockito.anyString(), Mockito.anyString())).thenReturn(List.of(searchResult));
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)((Workspace)Mockito.mock(Workspace.class)));
        Mockito.when((Object)item.getName()).thenReturn((Object)"fileName");
        Mockito.when((Object)item.getPath()).thenReturn((Object)"path/Quarantine");
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"123");
        Mockito.when((Object)this.restoredDlpItemService.getRestoredDlpItemByReference(item.getUUID())).thenReturn((Object)new RestoredDlpItem());
        boolean process = this.fileDlpConnector.processItem("1");
        ((FileSearchServiceConnector)Mockito.verify((Object)this.fileSearchServiceConnector, (VerificationMode)Mockito.times((int)1))).searchByEntityId((SearchContext)Mockito.any(), Mockito.anyString(), Mockito.anyString());
        Assert.assertTrue((boolean)process);
        ((ExtendedSession)Mockito.doThrow((Throwable[])new Throwable[]{new RepositoryException()}).when((Object)session)).getNodeByIdentifier("1");
        Assert.assertTrue((boolean)this.fileDlpConnector.processItem("1"));
    }

    @Test
    public void restorePositiveItem() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node item = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Node parent = (Node)Mockito.mock(Node.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)session.getNodeByIdentifier("1")).thenReturn((Object)item);
        Mockito.when((Object)item.getName()).thenReturn((Object)"fileName");
        Node link = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.linkManager.getAllLinks(item, "exo:symlink", sessionProvider)).thenReturn(List.of(link));
        Mockito.when((Object)session.getItem("/Quarantine")).thenReturn((Object)item);
        Mockito.when((Object)item.getSession()).thenReturn((Object)session);
        Mockito.when((Object)item.getProperty("exo:restorePath")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"restorePath");
        Mockito.when((Object)item.getPath()).thenReturn((Object)"path");
        Mockito.when((Object)session.getItem("path")).thenReturn((Object)item);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)session.getItem("restorePath")).thenReturn((Object)item);
        Mockito.when((Object)item.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)parent.getNodes(item.getName())).thenReturn((Object)nodeIterator);
        this.fileDlpConnector.restorePositiveItem("1");
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).move("path", "restorePath");
        ((Node)Mockito.verify((Object)link, (VerificationMode)Mockito.times((int)1))).removeMixin("exo:exoDlpItem");
        ((Node)Mockito.verify((Object)link, (VerificationMode)Mockito.times((int)1))).save();
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("file", "1");
        ((RestoredDlpItemService)Mockito.verify((Object)this.restoredDlpItemService, (VerificationMode)Mockito.times((int)1))).addRestoredDlpItem((RestoredDlpItemEntity)Mockito.any());
    }

    @Test
    public void treatItem() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node item = (Node)Mockito.mock(Node.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)session.getNodeByIdentifier("1")).thenReturn((Object)item);
        Mockito.when((Object)item.getName()).thenReturn((Object)"fileName");
        Mockito.when((Object)item.getPath()).thenReturn((Object)"/Quarantine/path");
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"123");
        Mockito.when((Object)this.restoredDlpItemService.getRestoredDlpItemByReference(item.getUUID())).thenReturn((Object)new RestoredDlpItem());
        SearchResult searchResult = new SearchResult("url", "title", "test", "detail", "imageUri", 1321332L, 1L);
        searchResult.setExcerpts(Map.of("title", List.of("test")));
        this.fileDlpConnector.treatItem("1", List.of(searchResult));
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)0))).move(item.getPath(), "/Quarantine/fileName");
        Mockito.when((Object)this.restoredDlpItemService.getRestoredDlpItemByReference(item.getUUID())).thenReturn(null);
        Node link = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.linkManager.getAllLinks(item, "exo:symlink", sessionProvider)).thenReturn(List.of(link));
        Mockito.when((Object)item.getPath()).thenReturn((Object)"/path");
        COMMONS_UTILS.when(() -> CommonsUtils.getService(DlpPositiveItemService.class)).thenReturn(Mockito.mock(DlpPositiveItemService.class));
        Property titleProperty = (Property)Mockito.mock(Property.class);
        Property lastModifierProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)titleProperty.getString()).thenReturn((Object)"title");
        Mockito.when((Object)item.getProperty("exo:title")).thenReturn((Object)titleProperty);
        Mockito.when((Object)item.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)lastModifierProperty.getString()).thenReturn((Object)"user");
        Mockito.when((Object)item.hasProperty("exo:lastModifier")).thenReturn((Object)true);
        Mockito.when((Object)item.getProperty("exo:lastModifier")).thenReturn((Object)lastModifierProperty);
        Mockito.when((Object)this.dlpOperationProcessor.getKeywords()).thenReturn((Object)"test");
        Mockito.when((Object)session.getItem("/Quarantine")).thenReturn((Object)item);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)item.getNodes("fileName")).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        this.fileDlpConnector.treatItem("1", List.of(searchResult));
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).unindex("file", "1");
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).move(item.getPath(), "/Quarantine/fileName");
    }

    @Test
    public void removePositiveItem() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node item = (Node)Mockito.mock(Node.class);
        Node dlpQuarantineNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getNodeByIdentifier("1")).thenReturn((Object)item);
        Mockito.when((Object)session.getItem("/Quarantine")).thenReturn((Object)dlpQuarantineNode);
        this.fileDlpConnector.removePositiveItem("1");
        UTILS.verify(() -> Mockito.times((int)1));
        Utils.removeDeadSymlinks((Node)item, (boolean)false);
        ((Node)Mockito.verify((Object)item, (VerificationMode)Mockito.times((int)1))).remove();
        ((Node)Mockito.verify((Object)dlpQuarantineNode, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void getItemUrl() throws Exception {
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getSystemSessionProvider()).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", repository)).thenReturn((Object)session);
        Node item = (Node)Mockito.mock(Node.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getNodeByIdentifier("1")).thenReturn((Object)item);
        Mockito.when((Object)item.getPath()).thenReturn((Object)"path");
        WCM_CORE_UTILS.when(() -> WCMCoreUtils.getLinkInDocumentsApplication((String)item.getPath())).thenReturn((Object)"/url/path");
        Assert.assertEquals((Object)"/url/path", (Object)this.fileDlpConnector.getItemUrl("1"));
    }
}

