/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es.index.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.es.client.ElasticContentRequestBuilder;
import org.exoplatform.addons.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.addons.es.client.ElasticIndexingClient;
import org.exoplatform.addons.es.dao.IndexingOperationDAO;
import org.exoplatform.addons.es.domain.IndexingOperation;
import org.exoplatform.addons.es.domain.OperationType;
import org.exoplatform.addons.es.index.IndexingOperationProcessor;
import org.exoplatform.addons.es.index.IndexingServiceConnector;
import org.exoplatform.addons.es.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ElasticIndexingOperationProcessor
extends IndexingOperationProcessor
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticIndexingOperationProcessor.class);
    private static final String BATCH_NUMBER_PROPERTY_NAME = "exo.es.indexing.batch.number";
    private static final Integer BATCH_NUMBER_DEFAULT = 1000;
    private static final String REQUEST_SIZE_LIMIT_PROPERTY_NAME = "exo.es.indexing.request.size.limit";
    private static final Integer REQUEST_SIZE_LIMIT_DEFAULT = 0xA00000;
    private static final String REINDEXING_BATCH_SIZE_PROPERTY_NAME = "exo.es.reindex.batch.size";
    private static final int REINDEXING_BATCH_SIZE_DEFAULT_VALUE = 100;
    private final IndexingOperationDAO indexingOperationDAO;
    private final ElasticIndexingClient elasticIndexingClient;
    private final ElasticContentRequestBuilder elasticContentRequestBuilder;
    private final ElasticIndexingAuditTrail auditTrail;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private Integer requestSizeLimit = REQUEST_SIZE_LIMIT_DEFAULT;
    private int reindexBatchSize = 100;

    public ElasticIndexingOperationProcessor(IndexingOperationDAO indexingOperationDAO, ElasticIndexingClient elasticIndexingClient, ElasticContentRequestBuilder elasticContentRequestBuilder, ElasticIndexingAuditTrail auditTrail, DataInitializer dataInitializer) {
        this.indexingOperationDAO = indexingOperationDAO;
        this.auditTrail = auditTrail;
        this.elasticIndexingClient = elasticIndexingClient;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME))) {
            this.batchNumber = Integer.valueOf(PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME))) {
            this.requestSizeLimit = Integer.valueOf(PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME))) {
            this.reindexBatchSize = Integer.valueOf(PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME));
        }
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.getConnectors().containsKey(indexingServiceConnector.getType()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getType()});
        } else {
            this.getConnectors().put(indexingServiceConnector.getType(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getType()});
        }
    }

    @Override
    public void process() {
        int processedOperations;
        while ((processedOperations = this.processBulk()) >= this.batchNumber) {
        }
    }

    private int processBulk() {
        HashMap<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted = new HashMap<OperationType, Map<String, List<IndexingOperation>>>();
        long maxIndexingOperationId = 0L;
        List<IndexingOperation> indexingOperations = this.indexingOperationDAO.findAllFirst(this.batchNumber);
        for (IndexingOperation indexingOperation : indexingOperations) {
            this.putIndexingOperationInMemoryQueue(indexingOperation, indexingQueueSorted);
            if (maxIndexingOperationId >= indexingOperation.getId()) continue;
            maxIndexingOperationId = indexingOperation.getId();
        }
        this.processInit(indexingQueueSorted);
        this.processDeleteAll(indexingQueueSorted);
        this.processReindexAll(indexingQueueSorted);
        this.processCUD(indexingQueueSorted);
        this.indexingOperationDAO.deleteAllIndexingOperationsHavingIdLessThanOrEqual(maxIndexingOperationId);
        return indexingOperations.size();
    }

    private void putIndexingOperationInMemoryQueue(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (!indexingQueueSorted.containsKey((Object)indexingOperation.getOperation())) {
            indexingQueueSorted.put(indexingOperation.getOperation(), new HashMap());
        }
        if (!indexingQueueSorted.get((Object)indexingOperation.getOperation()).containsKey(indexingOperation.getEntityType())) {
            indexingQueueSorted.get((Object)indexingOperation.getOperation()).put(indexingOperation.getEntityType(), new ArrayList());
        }
        indexingQueueSorted.get((Object)indexingOperation.getOperation()).get(indexingOperation.getEntityType()).add(indexingOperation);
    }

    private void processCUD(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        String bulkRequest = "";
        if (indexingQueueSorted.containsKey((Object)OperationType.DELETE)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.DELETE).keySet()) {
                for (IndexingOperation deleteIndexQueue : indexingQueueSorted.get((Object)OperationType.DELETE).get(entityType)) {
                    bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(deleteIndexQueue.getEntityType()), deleteIndexQueue.getEntityId());
                    this.deleteOperationsByEntityIdForTypesBefore(new OperationType[]{OperationType.CREATE}, indexingQueueSorted, deleteIndexQueue);
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, deleteIndexQueue);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.DELETE);
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.CREATE)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.CREATE).keySet()) {
                for (IndexingOperation createIndexQueue : indexingQueueSorted.get((Object)OperationType.CREATE).get(entityType)) {
                    bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getCreateDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(createIndexQueue.getEntityType()), createIndexQueue.getEntityId());
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.CREATE);
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.UPDATE)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.UPDATE).keySet()) {
                for (IndexingOperation updateIndexQueue : indexingQueueSorted.get((Object)OperationType.UPDATE).get(entityType)) {
                    bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getUpdateDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(updateIndexQueue.getEntityType()), updateIndexQueue.getEntityId());
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.UPDATE);
        }
        if (StringUtils.isNotBlank((String)bulkRequest)) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
        }
    }

    private void processInit(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.INIT)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.INIT).keySet()) {
                this.sendInitRequests(this.getConnectors().get(entityType));
            }
            indexingQueueSorted.remove((Object)OperationType.INIT);
        }
    }

    private void processDeleteAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.DELETE_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).keySet()) {
                if (!indexingQueueSorted.get((Object)OperationType.DELETE_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).get(entityType)) {
                    this.processDeleteAll(indexingOperation, indexingQueueSorted);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.DELETE_ALL);
        }
    }

    private void processDeleteAll(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)this.getConnectors().get(indexingOperation.getEntityType());
        this.auditTrail.audit("delete_all", null, null, connector.getType(), null, null, 0L);
        this.elasticIndexingClient.sendDeleteTypeRequest(connector.getIndex(), connector.getType());
        this.elasticIndexingClient.sendCreateTypeRequest(connector.getIndex(), connector.getType(), connector.getMapping());
        this.deleteOperationsForTypesBefore(new OperationType[]{OperationType.CREATE, OperationType.UPDATE, OperationType.DELETE}, indexingQueueSorted, indexingOperation);
    }

    private void processReindexAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.REINDEX_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).keySet()) {
                if (!indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).get(entityType)) {
                    int numberIndexed;
                    long startTime = System.currentTimeMillis();
                    this.indexingOperationDAO.create(new IndexingOperation(null, entityType, OperationType.DELETE_ALL));
                    IndexingServiceConnector connector = this.getConnectors().get(indexingOperation.getEntityType());
                    int offset = 0;
                    do {
                        List<String> ids;
                        if ((ids = connector.getAllIds(offset, this.reindexBatchSize)) == null) {
                            numberIndexed = 0;
                            continue;
                        }
                        ArrayList<IndexingOperation> operations = new ArrayList<IndexingOperation>(ids.size());
                        for (String id : ids) {
                            operations.add(new IndexingOperation(id, entityType, OperationType.CREATE));
                        }
                        this.indexingOperationDAO.createAll(operations);
                        numberIndexed = ids.size();
                        offset += this.reindexBatchSize;
                    } while (numberIndexed == this.reindexBatchSize);
                    this.auditTrail.audit("reindex_all", null, null, entityType, null, null, System.currentTimeMillis() - startTime);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.REINDEX_ALL);
        }
    }

    private void deleteOperationsForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation refIindexOperation) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(refIindexOperation.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(refIindexOperation.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (refIindexOperation.getId() <= indexingOperation.getId()) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (indexQueue.getId() <= indexingOperation.getId() || !indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypes(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (!indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void sendInitRequests(IndexingServiceConnector IndexingServiceConnector2) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)IndexingServiceConnector2;
        this.elasticIndexingClient.sendCreateIndexRequest(connector.getIndex(), this.elasticContentRequestBuilder.getCreateIndexRequestContent(connector));
        this.elasticIndexingClient.sendCreateTypeRequest(connector.getIndex(), connector.getType(), connector.getMapping());
    }

    private String checkBulkRequestSizeReachedLimitation(String bulkRequest) {
        if (bulkRequest.getBytes().length >= this.requestSizeLimit) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
            return "";
        }
        return bulkRequest;
    }

    private void addInitOperation(String connector) {
        IndexingOperation indexingOperation = new IndexingOperation();
        indexingOperation.setEntityType(connector);
        indexingOperation.setOperation(OperationType.INIT);
        this.indexingOperationDAO.create(indexingOperation);
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getRequestSizeLimit() {
        return this.requestSizeLimit;
    }

    public void setRequestSizeLimit(Integer requestSizeLimit) {
        this.requestSizeLimit = requestSizeLimit;
    }

    public int getReindexBatchSize() {
        return this.reindexBatchSize;
    }

    public void setReindexBatchSize(int reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
    }

    public void start() {
        this.initConnectors();
    }

    public void stop() {
    }

    private void initConnectors() {
        for (Map.Entry<String, IndexingServiceConnector> entry : this.getConnectors().entrySet()) {
            this.addInitOperation(entry.getValue().getType());
        }
    }
}

